/*
 * Decompiled with CFR 0.152.
 */
package worker.export.order;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import model.config.GlobalVar;
import model.db.FieldMetaInfo;
import util.FileUtil;
import worker.common.writer.IFileWriter;
import worker.common.writer.NioFileWriter;

public abstract class MergeExportConsumer {
    protected final List<FieldMetaInfo> orderByColumnInfoList;
    protected final boolean isAscending = true;
    protected int curLineNum = 0;
    protected int bufferedLineNum = 0;
    protected int curFileSeq = 0;
    protected ByteArrayOutputStream outputStream;
    protected final int maxLine;
    protected final String filePath;
    protected final byte[] separator;
    protected final IFileWriter fileWriter;
    protected Comparator comparator;

    protected MergeExportConsumer(List<FieldMetaInfo> orderByColumnInfoList, int maxLine, String filePath, byte[] separator) {
        this.orderByColumnInfoList = orderByColumnInfoList;
        this.maxLine = maxLine;
        this.filePath = filePath;
        this.separator = separator;
        this.outputStream = new ByteArrayOutputStream();
        this.fileWriter = new NioFileWriter(filePath + this.curFileSeq);
    }

    protected void writeToBuffer(byte[][] rowData) throws IOException {
        if (rowData.length == 0) {
            return;
        }
        ++this.curLineNum;
        ++this.bufferedLineNum;
        if (this.bufferedLineNum == GlobalVar.EMIT_BATCH_SIZE) {
            this.fileWriter.write(this.outputStream.toByteArray());
            this.outputStream.reset();
            this.bufferedLineNum = 0;
        }
        if (this.maxLine != 0 && this.curLineNum == this.maxLine) {
            this.createNewPartFile();
        }
        for (int i = 0; i < rowData.length - 1; ++i) {
            this.outputStream.write(rowData[i]);
            this.outputStream.write(this.separator);
        }
        this.outputStream.write(rowData[rowData.length - 1]);
        this.outputStream.write(FileUtil.SYS_NEW_LINE_BYTE);
    }

    private void createNewPartFile() {
        if (this.bufferedLineNum != 0) {
            this.fileWriter.write(this.outputStream.toByteArray());
            this.outputStream.reset();
            this.bufferedLineNum = 0;
        }
        ++this.curFileSeq;
        String tmpFileName = this.filePath + this.curFileSeq;
        this.fileWriter.nextFile(tmpFileName);
    }
}

