/*
 * Decompiled with CFR 0.152.
 */
package worker.export.order;

import com.alibaba.druid.util.JdbcUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;
import model.db.TableFieldMetaInfo;
import model.db.TableTopology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import util.DataSourceUtil;
import worker.export.order.LocalOrderByExportProducer;
import worker.export.order.OrderByExportEvent;
import worker.util.ExportUtil;

public class OrderByExportProducer
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(OrderByExportProducer.class);
    private String whereCondition;
    private final int queueIndex;
    private final LinkedBlockingQueue<OrderByExportEvent> orderByExportEventQueue;
    private final DataSource druid;
    private final TableTopology topology;
    private final TableFieldMetaInfo tableFieldMetaInfo;
    private final List<String> orderByColumnName;
    private final AtomicBoolean finished;
    private boolean isAscending = true;

    public OrderByExportProducer(DataSource druid, TableTopology topology, TableFieldMetaInfo tableFieldMetaInfo, LinkedBlockingQueue<OrderByExportEvent> orderByExportEventQueue, int queueIndex, List<String> orderByColumnName, AtomicBoolean finished) {
        this.tableFieldMetaInfo = tableFieldMetaInfo;
        this.queueIndex = queueIndex;
        this.orderByExportEventQueue = orderByExportEventQueue;
        this.druid = druid;
        this.orderByColumnName = orderByColumnName;
        this.topology = topology;
        this.finished = finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void produceData() {
        Connection conn = null;
        Statement stmt = null;
        ResultSet resultSet = null;
        String sql = ExportUtil.getOrderBySql(this.topology, this.tableFieldMetaInfo.getFieldMetaInfoList(), this.orderByColumnName, this.whereCondition, this.isAscending);
        long startTime = System.currentTimeMillis();
        try {
            conn = this.druid.getConnection();
            stmt = DataSourceUtil.createStreamingStatement(conn);
            resultSet = stmt.executeQuery(sql);
            int colNum = resultSet.getMetaData().getColumnCount();
            while (resultSet.next()) {
                byte[][] data = LocalOrderByExportProducer.getRowBytes(resultSet, colNum);
                OrderByExportEvent exportEvent = new OrderByExportEvent(this.queueIndex, data);
                this.orderByExportEventQueue.put(exportEvent);
            }
            long endTime = System.currentTimeMillis();
            logger.debug("{} \u53d1\u9001\u5b8c\u6210\uff0c\u8017\u65f6 {} s", (Object)this.topology, (Object)Float.valueOf((float)(endTime - startTime) / 1000.0f));
        }
        catch (InterruptedException | SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.finished.set(true);
            this.orderByExportEventQueue.offer(new OrderByExportEvent(this.queueIndex));
            JdbcUtils.close(resultSet);
            JdbcUtils.close(stmt);
            JdbcUtils.close(conn);
        }
    }

    @Override
    public void run() {
        this.produceData();
    }

    public boolean isAscending() {
        return this.isAscending;
    }

    public void setAscending(boolean ascending) {
        this.isAscending = ascending;
    }

    public void setWhereCondition(String whereCondition) {
        this.whereCondition = whereCondition;
    }
}

