/*
 * Decompiled with CFR 0.152.
 */
package worker.export.order;

import java.io.IOException;
import java.util.List;
import java.util.PriorityQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import model.db.FieldMetaInfo;
import worker.export.order.MergeExportConsumer;
import worker.export.order.OrderByExportEvent;
import worker.util.ExportUtil;

public class OrderByMergeExportConsumer
extends MergeExportConsumer {
    private final LinkedBlockingQueue[] orderedQueues;
    private final AtomicBoolean[] finishedList;
    private final PriorityQueue<OrderByExportEvent> priorityQueue;

    public OrderByMergeExportConsumer(String filePath, String separator, List<FieldMetaInfo> orderByColumnInfoList, LinkedBlockingQueue[] orderedQueues, AtomicBoolean[] finishedList, int maxLine) {
        super(orderByColumnInfoList, maxLine, filePath, separator.getBytes());
        this.orderedQueues = orderedQueues;
        this.finishedList = finishedList;
        this.comparator = ExportUtil.getCombinedComparator(orderByColumnInfoList);
        this.priorityQueue = new PriorityQueue(orderedQueues.length, this.comparator);
    }

    public void consume() throws InterruptedException {
        OrderByExportEvent prioriElement;
        OrderByExportEvent orderByExportEvent;
        for (int i = 0; i < this.orderedQueues.length; ++i) {
            if (this.finishedList[i].get() && this.orderedQueues[i].isEmpty() || (orderByExportEvent = (OrderByExportEvent)this.orderedQueues[i].take()) == null || orderByExportEvent.isEmpty()) continue;
            this.priorityQueue.offer(orderByExportEvent);
        }
        if (this.priorityQueue.isEmpty()) {
            return;
        }
        while ((prioriElement = this.priorityQueue.poll()) != null) {
            int queueIndex = prioriElement.getQueueIndex();
            try {
                this.writeToBuffer(prioriElement.getData());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (!this.finishedList[queueIndex].get() || !this.orderedQueues[queueIndex].isEmpty()) {
                orderByExportEvent = (OrderByExportEvent)this.orderedQueues[queueIndex].take();
                if (orderByExportEvent == null || orderByExportEvent.isEmpty()) continue;
                this.priorityQueue.offer(orderByExportEvent);
                continue;
            }
            if (!this.priorityQueue.isEmpty()) continue;
            break;
        }
        this.fileWriter.write(this.outputStream.toByteArray());
    }
}

