/*
 * Decompiled with CFR 0.152.
 */
package worker.export.order;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import model.db.FieldMetaInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import worker.MyThreadPool;
import worker.export.order.MergeExportConsumer;
import worker.export.order.ParallelOrderByExportEvent;
import worker.util.ExportUtil;

public class ParallelMergeExportConsumer
extends MergeExportConsumer {
    private static final Logger logger = LoggerFactory.getLogger(ParallelMergeExportConsumer.class);
    private final LinkedList[] orderedLists;

    public ParallelMergeExportConsumer(String filePath, String separator, List<FieldMetaInfo> orderByColumnInfoList, LinkedList[] orderedLists, int maxLine) {
        super(orderByColumnInfoList, maxLine, filePath, separator.getBytes());
        this.orderedLists = orderedLists;
        this.comparator = ExportUtil.getCombinedParallelOrderComparator(orderByColumnInfoList);
    }

    public void consume() throws InterruptedException {
        int count = this.orderedLists.length;
        assert (Integer.bitCount(count) == 1);
        LinkedBlockingDeque<LinkedList<ParallelOrderByExportEvent>> linkedListQueue = new LinkedBlockingDeque<LinkedList<ParallelOrderByExportEvent>>();
        ThreadPoolExecutor executor = MyThreadPool.createExecutorWithEnsure("ParallelMergeExportConsumer", count);
        AtomicInteger runningThreadCount = new AtomicInteger(count / 2);
        logger.info("\u5f00\u59cb\u5f52\u5e76");
        for (int i = 0; i < count; i += 2) {
            MergeThread mergeThread = new MergeThread(this.orderedLists[i], this.orderedLists[i + 1], linkedListQueue, runningThreadCount);
            executor.submit(mergeThread);
        }
        while (runningThreadCount.get() + linkedListQueue.size() >= 2) {
            logger.debug("\u5f53\u524d\u961f\u5217\u5927\u5c0f {}, \u5f52\u5e76\u7ebf\u7a0b\u6570 {} ", (Object)linkedListQueue.size(), (Object)runningThreadCount.get());
            LinkedList<ParallelOrderByExportEvent> list1 = linkedListQueue.take();
            logger.debug("Take\u540e\u5f53\u524d\u961f\u5217\u5927\u5c0f {}, \u5f52\u5e76\u7ebf\u7a0b\u6570 {} ", (Object)linkedListQueue.size(), (Object)runningThreadCount.get());
            LinkedList<ParallelOrderByExportEvent> list2 = linkedListQueue.take();
            runningThreadCount.incrementAndGet();
            MergeThread mergeThread = new MergeThread(list1, list2, linkedListQueue, runningThreadCount);
            executor.submit(mergeThread);
        }
        logger.debug("\u5f52\u5e76\u7ed3\u675f\uff0c\u961f\u5217\u957f\u5ea6\u4e3a{}\uff0c\u5f00\u59cb\u5199\u5165\u6587\u4ef6", (Object)linkedListQueue.size());
        LinkedList finalResult = (LinkedList)linkedListQueue.take();
        try {
            for (ParallelOrderByExportEvent parallelOrderByExportEvent : finalResult) {
                this.writeToBuffer(parallelOrderByExportEvent.getData());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
        logger.info("\u5199\u5165\u6587\u4ef6\u7ed3\u675f");
    }

    private LinkedList<ParallelOrderByExportEvent> mergeTwoList(LinkedList<ParallelOrderByExportEvent> list1, LinkedList<ParallelOrderByExportEvent> list2) {
        ListIterator it1 = list1.listIterator();
        ListIterator it2 = list2.listIterator();
        LinkedList<ParallelOrderByExportEvent> result = new LinkedList<ParallelOrderByExportEvent>();
        while (it1.hasNext() || it2.hasNext()) {
            if (it1.hasNext() && it2.hasNext()) {
                ParallelOrderByExportEvent val2;
                ParallelOrderByExportEvent val0 = (ParallelOrderByExportEvent)it1.next();
                if (this.comparator.compare(val0, val2 = (ParallelOrderByExportEvent)it2.next()) > 0) {
                    result.add(val0);
                    it2.previous();
                    continue;
                }
                result.add(val2);
                it1.previous();
                continue;
            }
            if (!it1.hasNext()) {
                result.add((ParallelOrderByExportEvent)it2.next());
                continue;
            }
            result.add((ParallelOrderByExportEvent)it1.next());
        }
        return result;
    }

    private class MergeThread
    implements Runnable {
        LinkedList<ParallelOrderByExportEvent> list1;
        LinkedList<ParallelOrderByExportEvent> list2;
        Queue<LinkedList<ParallelOrderByExportEvent>> linkedListQueue;
        AtomicInteger runningThreadCount;

        public MergeThread(LinkedList<ParallelOrderByExportEvent> list1, LinkedList<ParallelOrderByExportEvent> list2, Queue<LinkedList<ParallelOrderByExportEvent>> linkedListQueue, AtomicInteger runningThreadCount) {
            this.list1 = list1;
            this.list2 = list2;
            this.linkedListQueue = linkedListQueue;
            this.runningThreadCount = runningThreadCount;
        }

        @Override
        public void run() {
            LinkedList mergeResult = ParallelMergeExportConsumer.this.mergeTwoList(this.list1, this.list2);
            logger.info("{}\u5f52\u5e76\u5b8c\u6bd5\uff0c\u653e\u5165\u961f\u5217\u4e2d\uff0c\u6b64\u65f6\u5f52\u5e76\u7ebf\u7a0b\u6570\u4e3a {}", (Object)Thread.currentThread().getName(), (Object)this.runningThreadCount.get());
            this.linkedListQueue.offer(mergeResult);
            this.runningThreadCount.getAndDecrement();
        }
    }
}

