/*
 * Decompiled with CFR 0.152.
 */
package worker.insert;

import exception.DatabaseException;
import java.util.List;
import model.db.FieldMetaInfo;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import worker.common.BaseDefaultConsumer;
import worker.util.ImportUtil;

public class ImportConsumer
extends BaseDefaultConsumer {
    private static final Logger logger = LoggerFactory.getLogger(ImportConsumer.class);
    private List<FieldMetaInfo> fieldMetaInfoList;
    private String columns = null;
    private StringBuilder insertSqlBuilder;

    @Override
    protected void initLocalVars() {
        super.initLocalVars();
        this.fieldMetaInfoList = this.consumerContext.getTableFieldMetaInfo(this.tableName).getFieldMetaInfoList();
        this.estimateFieldCount = this.fieldMetaInfoList.size();
        this.columns = this.consumerContext.getUseColumns();
        this.insertSqlBuilder = new StringBuilder(64 + this.fieldMetaInfoList.size() * 16);
    }

    @Override
    protected void fillLocalBuffer(StringBuilder stringBuilder, List<String> values) {
        stringBuilder.append("(");
        try {
            ImportUtil.appendValuesByFieldMetaInfo(stringBuilder, this.fieldMetaInfoList, values, this.consumerContext.isSqlEscapeEnabled(), this.hasEscapedQuote);
        }
        catch (DatabaseException e) {
            logger.error(StringUtils.join(values, "|@|"));
            throw new RuntimeException(e);
        }
        stringBuilder.append("),");
    }

    @Override
    protected String getSql(StringBuilder data) {
        data.setLength(data.length() - 1);
        ImportUtil.getBatchInsertSql(this.insertSqlBuilder, this.tableName, this.columns, data, this.consumerContext.isInsertIgnoreAndResumeEnabled());
        String sql = this.insertSqlBuilder.toString();
        this.insertSqlBuilder.setLength(0);
        return sql;
    }
}

