/*
 * Decompiled with CFR 0.152.
 */
package worker.insert;

import com.alibaba.druid.util.JdbcUtils;
import com.alibaba.druid.util.StringUtils;
import exception.DatabaseException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import model.db.FieldMetaInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import util.FileUtil;
import worker.common.BaseWorkHandler;
import worker.common.BatchLineEvent;
import worker.util.ImportUtil;

public class ProcessOnlyImportConsumer
extends BaseWorkHandler {
    private static final Logger logger = LoggerFactory.getLogger(ProcessOnlyImportConsumer.class);

    @Override
    public void onProxyEvent(BatchLineEvent event) {
        try {
            String[] lines = event.getBatchLines();
            List<FieldMetaInfo> fieldMetaInfoList = this.consumerContext.getTableFieldMetaInfo(this.tableName).getFieldMetaInfoList();
            int estimateLineSize = 10;
            if (lines.length > 0 && lines[0] != null) {
                estimateLineSize = Math.min(estimateLineSize, lines[0].length());
            }
            StringBuilder stringBuilder = new StringBuilder(lines.length * estimateLineSize);
            for (String line : lines) {
                if (StringUtils.isEmpty(line)) continue;
                if (line == "END_OF_BATCH_LINES") break;
                List<String> values = FileUtil.split(line, this.consumerContext.getSeparator(), this.consumerContext.isWithLastSep(), this.hasEscapedQuote);
                stringBuilder.append("(");
                try {
                    ImportUtil.appendValuesByFieldMetaInfo(stringBuilder, fieldMetaInfoList, values, this.consumerContext.isSqlEscapeEnabled(), this.hasEscapedQuote);
                }
                catch (DatabaseException e) {
                    logger.error("Error {} at line: {}", (Object)e.getMessage(), (Object)line);
                    stringBuilder.setLength(stringBuilder.length() - 1);
                    continue;
                }
                stringBuilder.append("),");
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.setLength(stringBuilder.length() - 1);
            }
            this.insertData(stringBuilder.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertData(String data) {
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = this.consumerContext.getDataSource().getConnection();
            stmt = conn.createStatement();
            String string = ImportUtil.getBatchInsertSql(this.tableName, data, this.consumerContext.isInsertIgnoreAndResumeEnabled());
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                logger.error(e.getMessage());
                System.exit(1);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(stmt);
                JdbcUtils.close(conn);
                this.consumerContext.getEmittedDataCounter().getAndDecrement();
                throw throwable;
            }
            JdbcUtils.close(stmt);
            JdbcUtils.close(conn);
            this.consumerContext.getEmittedDataCounter().getAndDecrement();
        }
        JdbcUtils.close(stmt);
        JdbcUtils.close(conn);
        this.consumerContext.getEmittedDataCounter().getAndDecrement();
    }
}

