/*
 * Decompiled with CFR 0.152.
 */
package worker.insert;

import java.util.List;
import model.db.FieldMetaInfo;
import model.db.TableTopology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import worker.common.BaseShardedConsumer;
import worker.util.ImportUtil;

public class ShardedImportConsumer
extends BaseShardedConsumer {
    private static final Logger logger = LoggerFactory.getLogger(ShardedImportConsumer.class);

    @Override
    protected void fillLocalBuffer(StringBuilder localBuffer, List<String> values, List<FieldMetaInfo> fieldMetaInfoList) throws Throwable {
        localBuffer.append("(");
        ImportUtil.appendValuesByFieldMetaInfo(localBuffer, fieldMetaInfoList, values, this.consumerContext.isSqlEscapeEnabled(), this.hasEscapedQuote);
        localBuffer.append("),");
    }

    @Override
    protected String getSqlWithHint(TableTopology topology, StringBuilder data) {
        data.setLength(data.length() - 1);
        return ImportUtil.getBatchInsertSqlWithHint(topology.getGroupName(), topology.getTableName(), data.toString(), this.consumerContext.isInsertIgnoreAndResumeEnabled());
    }
}

