/*
 * Decompiled with CFR 0.152.
 */
package worker.tpch;

import com.lmax.disruptor.WorkHandler;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import model.ConsumerExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import worker.tpch.BatchInsertSqlEvent;

public class TpchConsumer
implements WorkHandler<BatchInsertSqlEvent> {
    private static final Logger logger = LoggerFactory.getLogger(TpchConsumer.class);
    protected final ConsumerExecutionContext consumerContext;

    public TpchConsumer(ConsumerExecutionContext consumerContext) {
        this.consumerContext = consumerContext;
    }

    @Override
    public void onEvent(BatchInsertSqlEvent event) {
        String sql = event.getSql();
        try (Connection conn = this.consumerContext.getDataSource().getConnection();
             Statement stmt = conn.createStatement();){
            stmt.execute(sql);
        }
        catch (SQLException e) {
            logger.error(sql.substring(0, Math.min(32, sql.length())) + ", due to" + e.getMessage());
            this.consumerContext.setException(e);
            throw new RuntimeException(e);
        }
        finally {
            this.consumerContext.getEmittedDataCounter().decrementAndGet();
        }
    }
}

