/*
 * Decompiled with CFR 0.152.
 */
package worker.tpch;

import com.lmax.disruptor.RingBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import model.ProducerExecutionContext;
import model.config.GlobalVar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import worker.common.Producer;
import worker.tpch.BatchInsertSqlEvent;
import worker.tpch.TpchTableModel;
import worker.tpch.generator.CustomerGenerator;
import worker.tpch.generator.LineItemGenerator;
import worker.tpch.generator.NationGenerator;
import worker.tpch.generator.OrderGenerator;
import worker.tpch.generator.PartGenerator;
import worker.tpch.generator.PartSupplierGenerator;
import worker.tpch.generator.RegionGenerator;
import worker.tpch.generator.SupplierGenerator;
import worker.tpch.generator.TableRowGenerator;

public class TpchProducer
implements Producer {
    private static final Logger logger = LoggerFactory.getLogger(TpchProducer.class);
    private final ProducerExecutionContext context;
    private final RingBuffer<BatchInsertSqlEvent> ringBuffer;
    private final ThreadPoolExecutor executor;
    private final int scale;
    private int workerCount;
    private Map<TpchTableModel, List<TableRowGenerator>> tableGeneratorsMap;

    public TpchProducer(ProducerExecutionContext context, List<String> tableNames, RingBuffer<BatchInsertSqlEvent> ringBuffer) {
        this.context = context;
        this.ringBuffer = ringBuffer;
        this.scale = context.getScale();
        if (this.scale <= 0) {
            throw new IllegalArgumentException("Scale must be a positive integer");
        }
        this.executor = context.getProducerExecutor();
        this.tableGeneratorsMap = new HashMap<TpchTableModel, List<TableRowGenerator>>();
        this.initGenerators(tableNames);
        this.initWorkerCount();
    }

    private void initGenerators(List<String> tableNames) {
        if (tableNames == null || tableNames.isEmpty()) {
            this.addRegionGenerator();
            this.addNationGenerator();
            this.addCustomerGenerator();
            this.addPartGenerator();
            this.addSupplierGenerator();
            this.addPartSuppGenerator();
            this.addOrdersGenerator();
            this.addLineitemGenerator();
            return;
        }
        Set tables = tableNames.stream().map(TpchTableModel::parse).collect(Collectors.toSet());
        block10: for (TpchTableModel table : tables) {
            switch (table) {
                case LINEITEM: {
                    this.addLineitemGenerator();
                    continue block10;
                }
                case CUSTOMER: {
                    this.addCustomerGenerator();
                    continue block10;
                }
                case ORDERS: {
                    this.addOrdersGenerator();
                    continue block10;
                }
                case PART: {
                    this.addPartGenerator();
                    continue block10;
                }
                case SUPPLIER: {
                    this.addSupplierGenerator();
                    continue block10;
                }
                case PART_SUPP: {
                    this.addPartSuppGenerator();
                    continue block10;
                }
                case NATION: {
                    this.addNationGenerator();
                    continue block10;
                }
                case REGION: {
                    this.addRegionGenerator();
                    continue block10;
                }
            }
            throw new UnsupportedOperationException(table.getName());
        }
    }

    private void initWorkerCount() {
        this.workerCount = this.tableGeneratorsMap.values().stream().mapToInt(List::size).sum();
    }

    public int getWorkerCount() {
        return this.workerCount;
    }

    private void addRegionGenerator() {
        ArrayList<RegionGenerator> regions = new ArrayList<RegionGenerator>(1);
        regions.add(new RegionGenerator());
        this.tableGeneratorsMap.put(TpchTableModel.REGION, regions);
    }

    private void addNationGenerator() {
        ArrayList<NationGenerator> nations = new ArrayList<NationGenerator>(1);
        nations.add(new NationGenerator());
        this.tableGeneratorsMap.put(TpchTableModel.NATION, nations);
    }

    private void addCustomerGenerator() {
        int customerPart = this.scale < 10 ? 1 : 4;
        ArrayList<CustomerGenerator> customers = new ArrayList<CustomerGenerator>(customerPart);
        for (int i = 1; i <= customerPart; ++i) {
            customers.add(new CustomerGenerator(this.scale, i, customerPart));
            this.tableGeneratorsMap.put(TpchTableModel.CUSTOMER, customers);
        }
    }

    private void addPartGenerator() {
        int partPart = this.scale < 10 ? 1 : 5;
        ArrayList<PartGenerator> parts = new ArrayList<PartGenerator>(partPart);
        for (int i = 1; i <= partPart; ++i) {
            parts.add(new PartGenerator(this.scale, i, partPart));
            this.tableGeneratorsMap.put(TpchTableModel.PART, parts);
        }
    }

    private void addSupplierGenerator() {
        boolean supplierPart = true;
        ArrayList<SupplierGenerator> suppliers = new ArrayList<SupplierGenerator>(1);
        for (int i = 1; i <= 1; ++i) {
            suppliers.add(new SupplierGenerator(this.scale, i, 1));
            this.tableGeneratorsMap.put(TpchTableModel.SUPPLIER, suppliers);
        }
    }

    private void addPartSuppGenerator() {
        int partSuppPart = this.scale < 10 ? 4 : 10;
        ArrayList<PartSupplierGenerator> partSupps = new ArrayList<PartSupplierGenerator>(partSuppPart);
        for (int i = 1; i <= partSuppPart; ++i) {
            partSupps.add(new PartSupplierGenerator(this.scale, i, partSuppPart));
            this.tableGeneratorsMap.put(TpchTableModel.PART_SUPP, partSupps);
        }
    }

    private void addOrdersGenerator() {
        int ordersPart = this.scale < 10 ? 8 : 30;
        ArrayList<OrderGenerator> orders = new ArrayList<OrderGenerator>(ordersPart);
        for (int i = 1; i <= ordersPart; ++i) {
            orders.add(new OrderGenerator(this.scale, i, ordersPart));
            this.tableGeneratorsMap.put(TpchTableModel.ORDERS, orders);
        }
    }

    private void addLineitemGenerator() {
        int lineitemPart = this.scale < 10 ? 16 : 60;
        ArrayList<LineItemGenerator> lineitems = new ArrayList<LineItemGenerator>(lineitemPart);
        for (int i = 1; i <= lineitemPart; ++i) {
            lineitems.add(new LineItemGenerator(this.scale, i, lineitemPart));
            this.tableGeneratorsMap.put(TpchTableModel.LINEITEM, lineitems);
        }
    }

    @Override
    public void produce() {
        boolean hasNext = true;
        HashMap<TpchTableModel, Iterator<TableRowGenerator>> iteratorMap = new HashMap<TpchTableModel, Iterator<TableRowGenerator>>(32);
        for (Map.Entry<TpchTableModel, List<TableRowGenerator>> entry : this.tableGeneratorsMap.entrySet()) {
            iteratorMap.put(entry.getKey(), entry.getValue().iterator());
        }
        HashMap<TpchTableModel, Integer> partMap = new HashMap<TpchTableModel, Integer>(32);
        while (hasNext) {
            hasNext = false;
            for (Map.Entry entry : iteratorMap.entrySet()) {
                if (!((Iterator)entry.getValue()).hasNext()) continue;
                hasNext = true;
                TpchTableModel table = (TpchTableModel)((Object)entry.getKey());
                int part = partMap.getOrDefault((Object)table, 1);
                TableRowGenerator nextGenerator = (TableRowGenerator)((Iterator)entry.getValue()).next();
                TpchTableWorker producer = new TpchTableWorker(this.ringBuffer, nextGenerator, table.getName(), table.getRowStrLen(), part);
                this.executor.submit(producer);
                partMap.put(table, part + 1);
            }
        }
    }

    class TpchTableWorker
    implements Runnable {
        protected final RingBuffer<BatchInsertSqlEvent> ringBuffer;
        protected final StringBuilder sqlBuffer;
        protected final TableRowGenerator rowGenerator;
        protected final String tableName;
        protected final int estimateRowLen;
        protected final int part;
        protected int bufferedLineCount = 0;

        TpchTableWorker(RingBuffer<BatchInsertSqlEvent> ringBuffer, TableRowGenerator rowGenerator, String tableName, int estimateRowLen, int part) {
            this.ringBuffer = ringBuffer;
            this.rowGenerator = rowGenerator;
            this.tableName = tableName;
            this.estimateRowLen = estimateRowLen;
            this.part = part;
            this.sqlBuffer = new StringBuilder("INSERT INTO  VALUES ()".length() + this.tableName.length() + GlobalVar.EMIT_BATCH_SIZE * (2 + estimateRowLen));
            this.refreshBuffer();
        }

        @Override
        public void run() {
            try {
                while (this.rowGenerator.hasNext()) {
                    this.rowGenerator.appendNextRow(this.sqlBuffer);
                    ++this.bufferedLineCount;
                    if (this.bufferedLineCount < GlobalVar.EMIT_BATCH_SIZE) continue;
                    this.emitLineBuffer();
                }
                if (this.bufferedLineCount != 0) {
                    this.emitLineBuffer();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                TpchProducer.this.context.getCountDownLatch().countDown();
                logger.info("{}-{} produce done", (Object)this.tableName, (Object)this.part);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void emitLineBuffer() {
            long sequence = this.ringBuffer.next();
            try {
                BatchInsertSqlEvent event = this.ringBuffer.get(sequence);
                this.sqlBuffer.setCharAt(this.sqlBuffer.length() - 1, ';');
                String sql = this.sqlBuffer.toString();
                event.setSql(sql);
                this.refreshBuffer();
            }
            finally {
                this.bufferedLineCount = 0;
                TpchProducer.this.context.getEmittedDataCounter().getAndIncrement();
                this.ringBuffer.publish(sequence);
            }
        }

        private void refreshBuffer() {
            this.sqlBuffer.setLength(0);
            this.sqlBuffer.append("INSERT INTO `").append(this.tableName).append("` VALUES ");
        }
    }
}

