/*
 * Decompiled with CFR 0.152.
 */
package worker.tpch;

public enum TpchTableModel {
    LINEITEM("lineitem", 16, 160),
    CUSTOMER("customer", 8, 176),
    ORDERS("orders", 9, 128),
    PART("part", 9, 128),
    SUPPLIER("supplier", 7, 128),
    PART_SUPP("partsupp", 5, 150),
    NATION("nation", 4, 90),
    REGION("region", 3, 135);

    private final String name;
    private final int fieldCount;
    private final int rowStrLen;

    private TpchTableModel(String name, int fieldCount, int rowStrLen) {
        this.name = name;
        this.fieldCount = fieldCount;
        this.rowStrLen = rowStrLen;
    }

    public static TpchTableModel parse(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Empty table name");
        }
        name = name.toLowerCase();
        for (TpchTableModel value : TpchTableModel.values()) {
            if (!value.name.equals(name)) continue;
            return value;
        }
        throw new IllegalArgumentException("Unsupported table name: " + name);
    }

    public String getName() {
        return this.name;
    }

    public int getFieldCount() {
        return this.fieldCount;
    }

    public int getRowStrLen() {
        return this.rowStrLen;
    }
}

