/*
 * Decompiled with CFR 0.152.
 */
package worker.tpch.generator;

import io.airlift.tpch.Distributions;
import io.airlift.tpch.GenerateUtils;
import io.airlift.tpch.RandomBoundedInt;
import io.airlift.tpch.RandomString;
import io.airlift.tpch.RandomText;
import io.airlift.tpch.TextPool;
import worker.tpch.generator.TableRowGenerator;
import worker.tpch.util.RandomAlphaNumeric;
import worker.tpch.util.RandomPhoneNumber;
import worker.tpch.util.StringBufferUtil;

public class CustomerGenerator
extends TableRowGenerator {
    public static final int SCALE_BASE = 150000;
    private static final int ACCOUNT_BALANCE_MIN = -99999;
    private static final int ACCOUNT_BALANCE_MAX = 999999;
    private static final int ADDRESS_AVERAGE_LENGTH = 25;
    private static final int COMMENT_AVERAGE_LENGTH = 73;
    private final RandomAlphaNumeric addressRandom = new RandomAlphaNumeric(881155353L, 25);
    private final RandomBoundedInt nationKeyRandom;
    private final RandomPhoneNumber phoneRandom = new RandomPhoneNumber(1521138112L);
    private final RandomBoundedInt accountBalanceRandom = new RandomBoundedInt(298370230L, -99999, 999999);
    private final RandomString marketSegmentRandom;
    private final RandomText commentRandom;

    public CustomerGenerator(double scaleFactor, int part, int partCount) {
        this(Distributions.getDefaultDistributions(), TextPool.getDefaultTestPool(), GenerateUtils.calculateStartIndex(150000, scaleFactor, part, partCount), GenerateUtils.calculateRowCount(150000, scaleFactor, part, partCount));
    }

    public CustomerGenerator(Distributions distributions, TextPool textPool, long startIndex, long rowCount) {
        super(distributions, textPool, startIndex, rowCount);
        this.nationKeyRandom = new RandomBoundedInt(1489529863L, 0, distributions.getNations().size() - 1);
        this.marketSegmentRandom = new RandomString(1140279430L, distributions.getMarketSegments());
        this.commentRandom = new RandomText(1335826707L, textPool, 73.0);
        this.addressRandom.advanceRows(startIndex);
        this.nationKeyRandom.advanceRows(startIndex);
        this.phoneRandom.advanceRows(startIndex);
        this.accountBalanceRandom.advanceRows(startIndex);
        this.marketSegmentRandom.advanceRows(startIndex);
        this.commentRandom.advanceRows(startIndex);
    }

    @Override
    public void appendNextRow(StringBuilder sqlBuffer) {
        long nationKey = this.nationKeyRandom.nextValue();
        long customerKey = this.startIndex + this.index + 1L;
        sqlBuffer.append('(').append(customerKey).append(",\"");
        StringBufferUtil.appendCustomerName(sqlBuffer, customerKey);
        sqlBuffer.append("\",\"");
        this.addressRandom.appendNextValue(sqlBuffer);
        sqlBuffer.append("\",").append(nationKey).append(",\"");
        this.phoneRandom.appendNextValue(sqlBuffer, nationKey);
        sqlBuffer.append("\",");
        StringBufferUtil.appendDecimalWithFrac2(sqlBuffer, this.accountBalanceRandom.nextValue());
        sqlBuffer.append(",\"").append(this.marketSegmentRandom.nextValue()).append("\",\"").append(this.commentRandom.nextValue()).append("\"),");
        this.addressRandom.rowFinished();
        this.nationKeyRandom.rowFinished();
        this.phoneRandom.rowFinished();
        this.accountBalanceRandom.rowFinished();
        this.marketSegmentRandom.rowFinished();
        this.commentRandom.rowFinished();
        ++this.index;
    }
}

