/*
 * Decompiled with CFR 0.152.
 */
package worker.tpch.generator;

import io.airlift.tpch.Distributions;
import io.airlift.tpch.GenerateUtils;
import io.airlift.tpch.RandomBoundedInt;
import io.airlift.tpch.RandomBoundedLong;
import io.airlift.tpch.RandomString;
import io.airlift.tpch.RandomText;
import io.airlift.tpch.TextPool;
import worker.tpch.generator.OrderGenerator;
import worker.tpch.generator.PartGenerator;
import worker.tpch.generator.PartSupplierGenerator;
import worker.tpch.generator.TableRowGenerator;
import worker.tpch.util.StringBufferUtil;

public class LineItemGenerator
extends TableRowGenerator {
    private static final int QUANTITY_MIN = 1;
    private static final int QUANTITY_MAX = 50;
    private static final int TAX_MIN = 0;
    private static final int TAX_MAX = 8;
    private static final int DISCOUNT_MIN = 0;
    private static final int DISCOUNT_MAX = 10;
    private static final int PART_KEY_MIN = 1;
    private static final int SHIP_DATE_MIN = 1;
    private static final int SHIP_DATE_MAX = 121;
    private static final int COMMIT_DATE_MIN = 30;
    private static final int COMMIT_DATE_MAX = 90;
    private static final int RECEIPT_DATE_MIN = 1;
    private static final int RECEIPT_DATE_MAX = 30;
    static final int ITEM_SHIP_DAYS = 151;
    private static final int COMMENT_AVERAGE_LENGTH = 27;
    private final RandomBoundedInt orderDateRandom = OrderGenerator.createOrderDateRandom();
    private final RandomBoundedInt lineCountRandom = OrderGenerator.createLineCountRandom();
    private final RandomBoundedInt quantityRandom = LineItemGenerator.createQuantityRandom();
    private final RandomBoundedInt discountRandom = LineItemGenerator.createDiscountRandom();
    private final RandomBoundedInt taxRandom = LineItemGenerator.createTaxRandom();
    private final RandomBoundedLong linePartKeyRandom;
    private final RandomBoundedInt supplierNumberRandom = new RandomBoundedInt(2095021727L, 0, 3, 7);
    private final RandomBoundedInt shipDateRandom = LineItemGenerator.createShipDateRandom();
    private final RandomBoundedInt commitDateRandom = new RandomBoundedInt(904914315L, 30, 90, 7);
    private final RandomBoundedInt receiptDateRandom = new RandomBoundedInt(373135028L, 1, 30, 7);
    private final RandomString returnedFlagRandom;
    private final RandomString shipInstructionsRandom;
    private final RandomString shipModeRandom;
    private final RandomText commentRandom;
    private final double scaleFactor;
    private int orderDate;
    private int lineCount;
    private int lineNumber;

    public LineItemGenerator(double scaleFactor, int part, int partCount) {
        this(Distributions.getDefaultDistributions(), TextPool.getDefaultTestPool(), scaleFactor, GenerateUtils.calculateStartIndex(1500000, scaleFactor, part, partCount), GenerateUtils.calculateRowCount(1500000, scaleFactor, part, partCount));
    }

    public LineItemGenerator(Distributions distributions, TextPool textPool, double scaleFactor, long startIndex, long rowCount) {
        super(distributions, textPool, startIndex, rowCount);
        this.scaleFactor = scaleFactor;
        this.returnedFlagRandom = new RandomString(717419739L, distributions.getReturnFlags(), 7);
        this.shipInstructionsRandom = new RandomString(1371272478L, distributions.getShipInstructions(), 7);
        this.shipModeRandom = new RandomString(675466456L, distributions.getShipModes(), 7);
        this.commentRandom = new RandomText(1095462486L, textPool, 27.0, 7);
        this.linePartKeyRandom = LineItemGenerator.createPartKeyRandom(scaleFactor);
        this.orderDateRandom.advanceRows(startIndex);
        this.lineCountRandom.advanceRows(startIndex);
        this.quantityRandom.advanceRows(startIndex);
        this.discountRandom.advanceRows(startIndex);
        this.taxRandom.advanceRows(startIndex);
        this.linePartKeyRandom.advanceRows(startIndex);
        this.supplierNumberRandom.advanceRows(startIndex);
        this.shipDateRandom.advanceRows(startIndex);
        this.commitDateRandom.advanceRows(startIndex);
        this.receiptDateRandom.advanceRows(startIndex);
        this.returnedFlagRandom.advanceRows(startIndex);
        this.shipInstructionsRandom.advanceRows(startIndex);
        this.shipModeRandom.advanceRows(startIndex);
        this.commentRandom.advanceRows(startIndex);
        this.orderDate = this.orderDateRandom.nextValue();
        this.lineCount = this.lineCountRandom.nextValue() - 1;
    }

    static RandomBoundedInt createQuantityRandom() {
        return new RandomBoundedInt(209208115L, 1, 50, 7);
    }

    static RandomBoundedInt createDiscountRandom() {
        return new RandomBoundedInt(554590007L, 0, 10, 7);
    }

    static RandomBoundedInt createTaxRandom() {
        return new RandomBoundedInt(721958466L, 0, 8, 7);
    }

    static RandomBoundedLong createPartKeyRandom(double scaleFactor) {
        return new RandomBoundedLong(1808217256L, scaleFactor >= 30000.0, 1L, (long)(200000.0 * scaleFactor), 7);
    }

    static RandomBoundedInt createShipDateRandom() {
        return new RandomBoundedInt(1769349045L, 1, 121, 7);
    }

    @Override
    public void appendNextRow(StringBuilder sqlBuffer) {
        long orderKey = OrderGenerator.makeOrderKey(this.startIndex + this.index + 1L);
        int quantity = this.quantityRandom.nextValue();
        int discount = this.discountRandom.nextValue();
        int tax = this.taxRandom.nextValue();
        long partKey = this.linePartKeyRandom.nextValue();
        int supplierNumber = this.supplierNumberRandom.nextValue();
        long supplierKey = PartSupplierGenerator.selectPartSupplier(partKey, supplierNumber, this.scaleFactor);
        long partPrice = PartGenerator.calculatePartPrice(partKey);
        long extendedPrice = partPrice * (long)quantity;
        int shipDate = this.shipDateRandom.nextValue();
        int commitDate = this.commitDateRandom.nextValue();
        commitDate += this.orderDate;
        int receiptDate = this.receiptDateRandom.nextValue();
        receiptDate += (shipDate += this.orderDate);
        shipDate = GenerateUtils.toEpochDate(shipDate);
        commitDate = GenerateUtils.toEpochDate(commitDate);
        String returnedFlag = GenerateUtils.isInPast(receiptDate = GenerateUtils.toEpochDate(receiptDate)) ? this.returnedFlagRandom.nextValue() : "N";
        String status = GenerateUtils.isInPast(shipDate) ? "F" : "O";
        String shipInstructions = this.shipInstructionsRandom.nextValue();
        String shipMode = this.shipModeRandom.nextValue();
        String comment = this.commentRandom.nextValue();
        sqlBuffer.append('(').append(orderKey).append(',').append(partKey).append(',').append(supplierKey).append(',').append(this.lineNumber + 1).append(',').append(quantity).append(",");
        StringBufferUtil.appendDecimalWithFrac2(sqlBuffer, extendedPrice);
        sqlBuffer.append(',');
        StringBufferUtil.appendDecimalWithFrac2(sqlBuffer, discount);
        sqlBuffer.append(',');
        StringBufferUtil.appendDecimalWithFrac2(sqlBuffer, tax);
        sqlBuffer.append(",\"").append(returnedFlag).append("\",\"").append(status).append("\",\"");
        StringBufferUtil.formatDateByDays(sqlBuffer, shipDate);
        sqlBuffer.append("\",\"");
        StringBufferUtil.formatDateByDays(sqlBuffer, commitDate);
        sqlBuffer.append("\",\"");
        StringBufferUtil.formatDateByDays(sqlBuffer, receiptDate);
        sqlBuffer.append("\",\"").append(shipInstructions).append("\",\"").append(shipMode).append("\",\"").append(comment).append("\"),");
        ++this.lineNumber;
        if (this.lineNumber > this.lineCount) {
            this.orderDateRandom.rowFinished();
            this.lineCountRandom.rowFinished();
            this.quantityRandom.rowFinished();
            this.discountRandom.rowFinished();
            this.taxRandom.rowFinished();
            this.linePartKeyRandom.rowFinished();
            this.supplierNumberRandom.rowFinished();
            this.shipDateRandom.rowFinished();
            this.commitDateRandom.rowFinished();
            this.receiptDateRandom.rowFinished();
            this.returnedFlagRandom.rowFinished();
            this.shipInstructionsRandom.rowFinished();
            this.shipModeRandom.rowFinished();
            this.commentRandom.rowFinished();
            ++this.index;
            this.lineCount = this.lineCountRandom.nextValue() - 1;
            this.orderDate = this.orderDateRandom.nextValue();
            this.lineNumber = 0;
        }
    }
}

