/*
 * Decompiled with CFR 0.152.
 */
package worker.tpch.generator;

import io.airlift.tpch.Distributions;
import io.airlift.tpch.GenerateUtils;
import io.airlift.tpch.RandomBoundedInt;
import io.airlift.tpch.RandomBoundedLong;
import io.airlift.tpch.RandomString;
import io.airlift.tpch.RandomText;
import io.airlift.tpch.TextPool;
import worker.tpch.generator.LineItemGenerator;
import worker.tpch.generator.PartGenerator;
import worker.tpch.generator.TableRowGenerator;
import worker.tpch.util.StringBufferUtil;

public class OrderGenerator
extends TableRowGenerator {
    public static final int SCALE_BASE = 1500000;
    public static final int CUSTOMER_MORTALITY = 3;
    static final int LINE_COUNT_MAX = 7;
    private static final int ORDER_DATE_MIN = 92001;
    private static final int ORDER_DATE_MAX = 94406;
    private static final int CLERK_SCALE_BASE = 1000;
    private static final int LINE_COUNT_MIN = 1;
    private static final int COMMENT_AVERAGE_LENGTH = 49;
    private static final int ORDER_KEY_SPARSE_BITS = 2;
    private static final int ORDER_KEY_SPARSE_KEEP = 3;
    private final RandomBoundedInt orderDateRandom = OrderGenerator.createOrderDateRandom();
    private final RandomBoundedInt lineCountRandom = OrderGenerator.createLineCountRandom();
    private final RandomBoundedLong customerKeyRandom;
    private final RandomString orderPriorityRandom;
    private final RandomBoundedInt clerkRandom;
    private final RandomText commentRandom;
    private final RandomBoundedInt lineQuantityRandom = LineItemGenerator.createQuantityRandom();
    private final RandomBoundedInt lineDiscountRandom = LineItemGenerator.createDiscountRandom();
    private final RandomBoundedInt lineTaxRandom = LineItemGenerator.createTaxRandom();
    private final RandomBoundedLong linePartKeyRandom;
    private final RandomBoundedInt lineShipDateRandom = LineItemGenerator.createShipDateRandom();
    private final long maxCustomerKey;

    public OrderGenerator(double scaleFactor, int part, int partCount) {
        this(Distributions.getDefaultDistributions(), TextPool.getDefaultTestPool(), scaleFactor, GenerateUtils.calculateStartIndex(1500000, scaleFactor, part, partCount), GenerateUtils.calculateRowCount(1500000, scaleFactor, part, partCount));
    }

    public OrderGenerator(Distributions distributions, TextPool textPool, double scaleFactor, long startIndex, long rowCount) {
        super(distributions, textPool, startIndex, rowCount);
        this.clerkRandom = new RandomBoundedInt(1171034773L, 1, Math.max((int)(scaleFactor * 1000.0), 1000));
        this.maxCustomerKey = (long)(150000.0 * scaleFactor);
        this.customerKeyRandom = new RandomBoundedLong(851767375L, scaleFactor >= 30000.0, 1L, this.maxCustomerKey);
        this.orderPriorityRandom = new RandomString(591449447L, distributions.getOrderPriorities());
        this.commentRandom = new RandomText(276090261L, textPool, 49.0);
        this.linePartKeyRandom = LineItemGenerator.createPartKeyRandom(scaleFactor);
        this.orderDateRandom.advanceRows(startIndex);
        this.lineCountRandom.advanceRows(startIndex);
        this.customerKeyRandom.advanceRows(startIndex);
        this.orderPriorityRandom.advanceRows(startIndex);
        this.clerkRandom.advanceRows(startIndex);
        this.commentRandom.advanceRows(startIndex);
        this.lineQuantityRandom.advanceRows(startIndex);
        this.lineDiscountRandom.advanceRows(startIndex);
        this.lineShipDateRandom.advanceRows(startIndex);
        this.lineTaxRandom.advanceRows(startIndex);
        this.linePartKeyRandom.advanceRows(startIndex);
    }

    static RandomBoundedInt createLineCountRandom() {
        return new RandomBoundedInt(1434868289L, 1, 7);
    }

    static RandomBoundedInt createOrderDateRandom() {
        return new RandomBoundedInt(1066728069L, 92001, 94406);
    }

    static long makeOrderKey(long orderIndex) {
        long lowBits = orderIndex & 7L;
        long key = orderIndex;
        key >>= 3;
        key <<= 2;
        key <<= 3;
        return key += lowBits;
    }

    @Override
    public void appendNextRow(StringBuilder sqlBuffer) {
        long orderKey = OrderGenerator.makeOrderKey(this.startIndex + this.index + 1L);
        int orderDate = this.orderDateRandom.nextValue();
        long customerKey = this.customerKeyRandom.nextValue();
        int delta = 1;
        while (customerKey % 3L == 0L) {
            customerKey += (long)delta;
            customerKey = Math.min(customerKey, this.maxCustomerKey);
            delta *= -1;
        }
        long totalPrice = 0L;
        int shippedCount = 0;
        int lineCount = this.lineCountRandom.nextValue();
        for (long lineNumber = 0L; lineNumber < (long)lineCount; ++lineNumber) {
            int quantity = this.lineQuantityRandom.nextValue();
            int discount = this.lineDiscountRandom.nextValue();
            int tax = this.lineTaxRandom.nextValue();
            long partKey = this.linePartKeyRandom.nextValue();
            long partPrice = PartGenerator.calculatePartPrice(partKey);
            long extendedPrice = partPrice * (long)quantity;
            long discountedPrice = extendedPrice * (long)(100 - discount);
            totalPrice += discountedPrice / 100L * (long)(100 + tax) / 100L;
            int shipDate = this.lineShipDateRandom.nextValue();
            if (!GenerateUtils.isInPast(shipDate += orderDate)) continue;
            ++shippedCount;
        }
        char orderStatus = shippedCount == lineCount ? (char)'F' : (shippedCount > 0 ? (char)'P' : 'O');
        sqlBuffer.append('(').append(orderKey).append(',').append(customerKey).append(",\"").append(orderStatus).append("\",");
        StringBufferUtil.appendDecimalWithFrac2(sqlBuffer, totalPrice);
        sqlBuffer.append(",\"");
        StringBufferUtil.formatDateByDays(sqlBuffer, orderDate);
        sqlBuffer.append("\",\"").append(this.orderPriorityRandom.nextValue()).append("\",\"");
        StringBufferUtil.appendClerk(sqlBuffer, this.clerkRandom.nextValue());
        sqlBuffer.append("\",").append(0).append(",\"").append(this.commentRandom.nextValue()).append("\"),");
        this.orderDateRandom.rowFinished();
        this.lineCountRandom.rowFinished();
        this.customerKeyRandom.rowFinished();
        this.orderPriorityRandom.rowFinished();
        this.clerkRandom.rowFinished();
        this.commentRandom.rowFinished();
        this.lineQuantityRandom.rowFinished();
        this.lineDiscountRandom.rowFinished();
        this.lineShipDateRandom.rowFinished();
        this.lineTaxRandom.rowFinished();
        this.linePartKeyRandom.rowFinished();
        ++this.index;
    }
}

