/*
 * Decompiled with CFR 0.152.
 */
package worker.tpch.generator;

import io.airlift.tpch.Distributions;
import io.airlift.tpch.GenerateUtils;
import io.airlift.tpch.RandomBoundedInt;
import io.airlift.tpch.RandomString;
import io.airlift.tpch.RandomStringSequence;
import io.airlift.tpch.RandomText;
import io.airlift.tpch.TextPool;
import worker.tpch.generator.TableRowGenerator;
import worker.tpch.util.StringBufferUtil;

public class PartGenerator
extends TableRowGenerator {
    public static final int SCALE_BASE = 200000;
    private static final int NAME_WORDS = 5;
    private static final int MANUFACTURER_MIN = 1;
    private static final int MANUFACTURER_MAX = 5;
    private static final int BRAND_MIN = 1;
    private static final int BRAND_MAX = 5;
    private static final int SIZE_MIN = 1;
    private static final int SIZE_MAX = 50;
    private static final int COMMENT_AVERAGE_LENGTH = 14;
    private final RandomStringSequence nameRandom;
    private final RandomBoundedInt manufacturerRandom;
    private final RandomBoundedInt brandRandom;
    private final RandomString typeRandom;
    private final RandomBoundedInt sizeRandom;
    private final RandomString containerRandom;
    private final RandomText commentRandom;

    public PartGenerator(double scaleFactor, int part, int partCount) {
        this(Distributions.getDefaultDistributions(), TextPool.getDefaultTestPool(), GenerateUtils.calculateStartIndex(200000, scaleFactor, part, partCount), GenerateUtils.calculateRowCount(200000, scaleFactor, part, partCount));
    }

    public PartGenerator(Distributions distributions, TextPool textPool, long startIndex, long rowCount) {
        super(distributions, textPool, startIndex, rowCount);
        this.nameRandom = new RandomStringSequence(709314158L, 5, distributions.getPartColors());
        this.manufacturerRandom = new RandomBoundedInt(1L, 1, 5);
        this.brandRandom = new RandomBoundedInt(46831694L, 1, 5);
        this.typeRandom = new RandomString(1841581359L, distributions.getPartTypes());
        this.sizeRandom = new RandomBoundedInt(1193163244L, 1, 50);
        this.containerRandom = new RandomString(727633698L, distributions.getPartContainers());
        this.commentRandom = new RandomText(804159733L, textPool, 14.0);
        this.nameRandom.advanceRows(startIndex);
        this.manufacturerRandom.advanceRows(startIndex);
        this.brandRandom.advanceRows(startIndex);
        this.typeRandom.advanceRows(startIndex);
        this.sizeRandom.advanceRows(startIndex);
        this.containerRandom.advanceRows(startIndex);
        this.commentRandom.advanceRows(startIndex);
    }

    @Override
    public void appendNextRow(StringBuilder sqlBuffer) {
        long partKey = this.startIndex + this.index + 1L;
        int manufacturer = this.manufacturerRandom.nextValue();
        int brand = manufacturer * 10 + this.brandRandom.nextValue();
        sqlBuffer.append('(').append(partKey).append(",\"").append(this.nameRandom.nextValue()).append("\",\"Manufacturer#").append(manufacturer).append("\",\"Brand").append(brand).append("\",\"").append(this.typeRandom.nextValue()).append("\",").append(this.sizeRandom.nextValue()).append(",\"").append(this.containerRandom.nextValue()).append("\",");
        StringBufferUtil.appendDecimalWithFrac2(sqlBuffer, PartGenerator.calculatePartPrice(partKey));
        sqlBuffer.append(",\"").append(this.commentRandom.nextValue()).append("\"),");
        this.nameRandom.rowFinished();
        this.manufacturerRandom.rowFinished();
        this.brandRandom.rowFinished();
        this.typeRandom.rowFinished();
        this.sizeRandom.rowFinished();
        this.containerRandom.rowFinished();
        this.commentRandom.rowFinished();
        ++this.index;
    }

    static long calculatePartPrice(long p) {
        long price = 90000L;
        price += p / 10L % 20001L;
        return price += p % 1000L * 100L;
    }
}

