/*
 * Decompiled with CFR 0.152.
 */
package worker.tpch.generator;

import io.airlift.tpch.GenerateUtils;
import io.airlift.tpch.RandomBoundedInt;
import io.airlift.tpch.RandomText;
import io.airlift.tpch.TextPool;
import worker.tpch.generator.TableRowGenerator;
import worker.tpch.util.StringBufferUtil;

public class PartSupplierGenerator
extends TableRowGenerator {
    private static final int SUPPLIERS_PER_PART = 4;
    private static final int AVAILABLE_QUANTITY_MIN = 1;
    private static final int AVAILABLE_QUANTITY_MAX = 9999;
    private static final int SUPPLY_COST_MIN = 100;
    private static final int SUPPLY_COST_MAX = 100000;
    private static final int COMMENT_AVERAGE_LENGTH = 124;
    private final double scaleFactor;
    private final RandomBoundedInt availableQuantityRandom;
    private final RandomBoundedInt supplyCostRandom;
    private final RandomText commentRandom;
    private int partSupplierNumber;

    public PartSupplierGenerator(double scaleFactor, int part, int partCount) {
        this(TextPool.getDefaultTestPool(), scaleFactor, GenerateUtils.calculateStartIndex(200000, scaleFactor, part, partCount), GenerateUtils.calculateRowCount(200000, scaleFactor, part, partCount));
    }

    public PartSupplierGenerator(TextPool textPool, double scaleFactor, long startIndex, long rowCount) {
        super(null, textPool, startIndex, rowCount);
        this.scaleFactor = scaleFactor;
        this.availableQuantityRandom = new RandomBoundedInt(1671059989L, 1, 9999, 4);
        this.supplyCostRandom = new RandomBoundedInt(1051288424L, 100, 100000, 4);
        this.commentRandom = new RandomText(1961692154L, textPool, 124.0, 4);
        this.availableQuantityRandom.advanceRows(startIndex);
        this.supplyCostRandom.advanceRows(startIndex);
        this.commentRandom.advanceRows(startIndex);
    }

    @Override
    public void appendNextRow(StringBuilder sqlBuffer) {
        long partKey = this.startIndex + this.index + 1L;
        sqlBuffer.append('(').append(partKey).append(',').append(PartSupplierGenerator.selectPartSupplier(partKey, this.partSupplierNumber, this.scaleFactor)).append(',').append(this.availableQuantityRandom.nextValue()).append(',');
        StringBufferUtil.appendDecimalWithFrac2(sqlBuffer, this.supplyCostRandom.nextValue());
        sqlBuffer.append(",\"").append(this.commentRandom.nextValue()).append("\"),");
        ++this.partSupplierNumber;
        if (this.partSupplierNumber >= 4) {
            this.availableQuantityRandom.rowFinished();
            this.supplyCostRandom.rowFinished();
            this.commentRandom.rowFinished();
            ++this.index;
            this.partSupplierNumber = 0;
        }
    }

    static long selectPartSupplier(long partKey, long supplierNumber, double scaleFactor) {
        long supplierCount = (long)(10000.0 * scaleFactor);
        return (partKey + supplierNumber * (supplierCount / 4L + (partKey - 1L) / supplierCount)) % supplierCount + 1L;
    }
}

