/*
 * Decompiled with CFR 0.152.
 */
package worker.tpch.generator;

import io.airlift.tpch.Distributions;
import io.airlift.tpch.GenerateUtils;
import io.airlift.tpch.RandomAlphaNumeric;
import io.airlift.tpch.RandomBoundedInt;
import io.airlift.tpch.RandomInt;
import io.airlift.tpch.RandomText;
import io.airlift.tpch.TextPool;
import worker.tpch.generator.TableRowGenerator;
import worker.tpch.util.RandomPhoneNumber;
import worker.tpch.util.StringBufferUtil;

public class SupplierGenerator
extends TableRowGenerator {
    public static final int SCALE_BASE = 10000;
    public static final String BBB_BASE_TEXT = "Customer ";
    public static final String BBB_COMPLAINT_TEXT = "Complaints";
    public static final String BBB_RECOMMEND_TEXT = "Recommends";
    public static final int BBB_COMMENT_LENGTH = "Customer ".length() + "Complaints".length();
    public static final int BBB_COMMENTS_PER_SCALE_BASE = 10;
    public static final int BBB_COMPLAINT_PERCENT = 50;
    private static final int ACCOUNT_BALANCE_MIN = -99999;
    private static final int ACCOUNT_BALANCE_MAX = 999999;
    private static final int ADDRESS_AVERAGE_LENGTH = 25;
    private static final int COMMENT_AVERAGE_LENGTH = 63;
    private final RandomAlphaNumeric addressRandom = new RandomAlphaNumeric(706178559L, 25);
    private final RandomBoundedInt nationKeyRandom;
    private final RandomPhoneNumber phoneRandom = new RandomPhoneNumber(884434366L);
    private final RandomBoundedInt accountBalanceRandom = new RandomBoundedInt(962338209L, -99999, 999999);
    private final RandomText commentRandom;
    private final RandomBoundedInt bbbCommentRandom = new RandomBoundedInt(202794285L, 1, 10000);
    private final RandomInt bbbJunkRandom = new RandomInt(263032577L, 1);
    private final RandomInt bbbOffsetRandom = new RandomInt(715851524L, 1);
    private final RandomBoundedInt bbbTypeRandom = new RandomBoundedInt(753643799L, 0, 100);

    public SupplierGenerator(double scaleFactor, int part, int partCount) {
        this(Distributions.getDefaultDistributions(), TextPool.getDefaultTestPool(), GenerateUtils.calculateStartIndex(10000, scaleFactor, part, partCount), GenerateUtils.calculateRowCount(10000, scaleFactor, part, partCount));
    }

    private SupplierGenerator(Distributions distributions, TextPool textPool, long startIndex, long rowCount) {
        super(distributions, textPool, startIndex, rowCount);
        this.nationKeyRandom = new RandomBoundedInt(110356601L, 0, distributions.getNations().size() - 1);
        this.commentRandom = new RandomText(1341315363L, textPool, 63.0);
        this.addressRandom.advanceRows(startIndex);
        this.nationKeyRandom.advanceRows(startIndex);
        this.phoneRandom.advanceRows(startIndex);
        this.accountBalanceRandom.advanceRows(startIndex);
        this.commentRandom.advanceRows(startIndex);
        this.bbbCommentRandom.advanceRows(startIndex);
        this.bbbJunkRandom.advanceRows(startIndex);
        this.bbbOffsetRandom.advanceRows(startIndex);
        this.bbbTypeRandom.advanceRows(startIndex);
    }

    @Override
    public void appendNextRow(StringBuilder sqlBuffer) {
        long supplierKey = this.startIndex + this.index + 1L;
        String comment = this.commentRandom.nextValue();
        StringBuilder commentBuffer = null;
        int bbbCommentRandomValue = this.bbbCommentRandom.nextValue();
        if (bbbCommentRandomValue <= 10) {
            commentBuffer = new StringBuilder(comment);
            int noise = this.bbbJunkRandom.nextInt(0, comment.length() - BBB_COMMENT_LENGTH);
            int offset = this.bbbOffsetRandom.nextInt(0, comment.length() - (BBB_COMMENT_LENGTH + noise));
            String type = this.bbbTypeRandom.nextValue() < 50 ? BBB_COMPLAINT_TEXT : BBB_RECOMMEND_TEXT;
            commentBuffer.replace(offset, offset + BBB_BASE_TEXT.length(), BBB_BASE_TEXT);
            commentBuffer.replace(BBB_BASE_TEXT.length() + offset + noise, BBB_BASE_TEXT.length() + offset + noise + type.length(), type);
        }
        long nationKey = this.nationKeyRandom.nextValue();
        sqlBuffer.append('(').append(supplierKey).append(",\"");
        StringBufferUtil.appendSupplier(sqlBuffer, supplierKey);
        sqlBuffer.append("\",\"").append(this.addressRandom.nextValue()).append("\",").append(nationKey).append(",\"");
        this.phoneRandom.appendNextValue(sqlBuffer, nationKey);
        sqlBuffer.append("\",");
        StringBufferUtil.appendDecimalWithFrac2(sqlBuffer, this.accountBalanceRandom.nextValue());
        if (commentBuffer == null) {
            sqlBuffer.append(",\"").append(comment).append("\"),");
        } else {
            sqlBuffer.append(",\"").append((CharSequence)commentBuffer).append("\"),");
        }
        this.addressRandom.rowFinished();
        this.nationKeyRandom.rowFinished();
        this.phoneRandom.rowFinished();
        this.accountBalanceRandom.rowFinished();
        this.commentRandom.rowFinished();
        this.bbbCommentRandom.rowFinished();
        this.bbbJunkRandom.rowFinished();
        this.bbbOffsetRandom.rowFinished();
        this.bbbTypeRandom.rowFinished();
        ++this.index;
    }
}

