/*
 * Decompiled with CFR 0.152.
 */
package worker.tpch.util;

public class StringBufferUtil {
    private static final int DAYS_PER_CYCLE = 146097;
    private static final long DAYS_0000_TO_1970 = 719528L;

    public static void appendDecimalWithFrac2(StringBuilder sqlBuffer, long l) {
        long intPart = l / 100L;
        long fracPart = l % 100L;
        sqlBuffer.append(intPart).append('.').append(fracPart);
    }

    public static void appendCustomerName(StringBuilder sqlBuffer, long key) {
        sqlBuffer.append("Customer#");
        StringBufferUtil.append9Digits(sqlBuffer, key);
    }

    public static void appendClerk(StringBuilder sqlBuffer, long key) {
        sqlBuffer.append("Clerk#");
        StringBufferUtil.append9Digits(sqlBuffer, key);
    }

    public static void appendSupplier(StringBuilder sqlBuffer, long key) {
        sqlBuffer.append("Supplier#");
        StringBufferUtil.append9Digits(sqlBuffer, key);
    }

    private static void append9Digits(StringBuilder sqlBuffer, long key) {
        if (key >= 10000L) {
            if (key >= 100000000L) {
                sqlBuffer.append(key);
            } else if (key >= 10000000L) {
                sqlBuffer.append('0').append(key);
            } else if (key >= 1000000L) {
                sqlBuffer.append("00").append(key);
            } else if (key >= 100000L) {
                sqlBuffer.append("000").append(key);
            } else {
                sqlBuffer.append("0000").append(key);
            }
        } else if (key >= 1000L) {
            sqlBuffer.append("00000").append(key);
        } else if (key >= 100L) {
            sqlBuffer.append("000000").append(key);
        } else if (key >= 10L) {
            sqlBuffer.append("0000000").append(key);
        } else if (key >= 0L) {
            sqlBuffer.append("00000000").append(key);
        }
    }

    public static void formatDateByDays(StringBuilder sqlBuffer, int days) {
        long yearEst;
        long doyEst;
        long zeroDay = (long)days + 719528L - 60L;
        long adjust = 0L;
        if (zeroDay < 0L) {
            long adjustCycles = (zeroDay + 1L) / 146097L - 1L;
            adjust = adjustCycles * 400L;
            zeroDay += -adjustCycles * 146097L;
        }
        if ((doyEst = zeroDay - (365L * (yearEst = (400L * zeroDay + 591L) / 146097L) + yearEst / 4L - yearEst / 100L + yearEst / 400L)) < 0L) {
            doyEst = zeroDay - (365L * --yearEst + yearEst / 4L - yearEst / 100L + yearEst / 400L);
        }
        yearEst += adjust;
        int marchDoy0 = (int)doyEst;
        int marchMonth0 = (marchDoy0 * 5 + 2) / 153;
        int month = (marchMonth0 + 2) % 12 + 1;
        int dom = marchDoy0 - (marchMonth0 * 306 + 5) / 10 + 1;
        int year = (int)(yearEst += (long)(marchMonth0 / 10));
        sqlBuffer.append(year).append('-');
        if (month < 10) {
            sqlBuffer.append('0');
        }
        sqlBuffer.append(month).append('-');
        if (dom < 10) {
            sqlBuffer.append('0');
        }
        sqlBuffer.append(dom);
    }
}

