/*
 * Decompiled with CFR 0.152.
 */
package worker.util;

import java.util.List;
import model.db.FieldMetaInfo;
import model.db.PrimaryKey;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import util.DbUtil;

public class DeleteUtil {
    private static final String BATCH_DELETE_HINT_SQL_PATTERN = "/*+TDDL:node='%s'*/ DELETE FROM `%s` WHERE (%s) IN (%s) ";
    private static final String BATCH_DELETE_WHERE_HINT_SQL_PATTERN = "/*+TDDL:node='%s'*/ DELETE FROM `%s` WHERE (%s) IN (%s) AND %s";

    public static String getBatchDeleteSql(String tableName, List<PrimaryKey> pkList, String values) {
        String sqlPattern = "DELETE FROM `%s` WHERE (%s) IN (%s);";
        String pkSet = DeleteUtil.formatPkList(pkList);
        return String.format(sqlPattern, tableName, pkSet, values);
    }

    public static String getBatchDeleteSql(String tableName, List<PrimaryKey> pkList, String values, String where) {
        if (StringUtils.isEmpty(where)) {
            return DeleteUtil.getBatchDeleteSql(tableName, pkList, values);
        }
        String sqlPattern = "DELETE FROM `%s` WHERE (%s) IN (%s) AND %s;";
        String pkSet = DeleteUtil.formatPkList(pkList);
        return String.format(sqlPattern, tableName, pkSet, values, where);
    }

    public static String getDeleteSqlWithHint(String nodeName, String tableName, List<PrimaryKey> pkList, String[] values, String where) {
        if (StringUtils.isEmpty(where)) {
            return DeleteUtil.getDeleteSqlWithHint(nodeName, tableName, pkList, values);
        }
        String sqlPattern = "/*+TDDL:node='%s'*/ DELETE FROM `%s` WHERE %s AND %s;";
        Object[] pkConditions = new String[pkList.size()];
        for (int i = 0; i < pkList.size(); ++i) {
            pkConditions[i] = pkList.get(i).getName() + "='" + values[i] + "'";
        }
        String pkCondition = StringUtils.join(pkConditions, " AND ");
        return String.format(sqlPattern, nodeName, tableName, pkCondition, where);
    }

    public static String getDeleteSqlWithHint(String nodeName, String tableName, List<PrimaryKey> pkList, String[] values) {
        String sqlPattern = "/*+TDDL:node='%s'*/ DELETE FROM `%s` WHERE %s ;";
        Object[] pkConditions = new String[pkList.size()];
        for (int i = 0; i < pkList.size(); ++i) {
            pkConditions[i] = pkList.get(i).getName() + "='" + values[i] + "'";
        }
        String pkCondition = StringUtils.join(pkConditions, " AND ");
        return String.format(sqlPattern, nodeName, tableName, pkCondition);
    }

    public static String getDeleteSql(String tableName, List<PrimaryKey> pkList, List<String> values, String where) {
        if (StringUtils.isEmpty(where)) {
            return DeleteUtil.getDeleteSql(tableName, pkList, values);
        }
        String sqlPattern = "DELETE FROM `%s` WHERE %s AND %s;";
        String pkCondition = DbUtil.formatPkConditions(pkList, values);
        return String.format(sqlPattern, tableName, pkCondition, where);
    }

    public static String getDeleteSql(String tableName, List<PrimaryKey> pkList, List<String> values) {
        String sqlPattern = "DELETE FROM `%s` WHERE %s;";
        String pkCondition = DbUtil.formatPkConditions(pkList, values);
        return String.format(sqlPattern, tableName, pkCondition);
    }

    public static String getBatchDeleteSqlWithHint(String nodeName, String tableName, List<PrimaryKey> pkList, String data, String where) {
        String pkSet = DeleteUtil.formatPkList(pkList);
        if (StringUtils.isEmpty(where)) {
            return String.format(BATCH_DELETE_HINT_SQL_PATTERN, nodeName, tableName, pkSet, data);
        }
        return String.format(BATCH_DELETE_WHERE_HINT_SQL_PATTERN, nodeName, tableName, pkSet, data, where);
    }

    public static String formatPkList(List<PrimaryKey> pkList) {
        Object[] pkNames = new String[pkList.size()];
        for (int i = 0; i < pkList.size(); ++i) {
            pkNames[i] = pkList.get(i).getName();
        }
        return StringUtils.join(pkNames, ",");
    }

    public static void appendPkValuesByFieldMetaInfo(StringBuilder localBuffer, List<FieldMetaInfo> fieldMetaInfoList, List<PrimaryKey> pkList, String[] pkValues) {
        int i;
        for (i = 0; i < pkList.size(); ++i) {
            int idx = pkList.get(i).getOrdinalPosition() - 1;
            if (fieldMetaInfoList.get(idx).getType() == FieldMetaInfo.Type.STRING || fieldMetaInfoList.get(idx).getType() == FieldMetaInfo.Type.OTHER) {
                localBuffer.append("'").append(StringEscapeUtils.escapeSql(pkValues[i])).append("'");
            } else {
                localBuffer.append(pkValues[i]);
            }
            localBuffer.append(",");
        }
        if (i > 0) {
            localBuffer.setLength(localBuffer.length() - 1);
        }
    }

    public static String getDeleteUsingIn(String tableName, String pkNames, String inPkValues) {
        String deleteSqlPattern = "delete from %s where (%s) in (%s)";
        return String.format(deleteSqlPattern, tableName, pkNames, inPkValues);
    }
}

