/*
 * Decompiled with CFR 0.152.
 */
package worker.util;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import model.db.FieldMetaInfo;
import model.db.TableTopology;
import org.apache.commons.lang.StringUtils;
import worker.export.order.OrderByExportEvent;
import worker.export.order.ParallelOrderByExportEvent;

public class ExportUtil {
    public static String getDirectSql(TableTopology topology, List<FieldMetaInfo> fieldMetaInfoList, String whereCondition) {
        if (StringUtils.isEmpty(whereCondition)) {
            return ExportUtil.getDirectSql(topology, fieldMetaInfoList);
        }
        return String.format("/*+TDDL:node='%s'*/ select %s from %s where %s;", topology.getGroupName(), ExportUtil.formatFieldWithDateType(fieldMetaInfoList), topology.getTableName(), whereCondition);
    }

    private static String getDirectSql(TableTopology topology, List<FieldMetaInfo> fieldMetaInfoList) {
        return String.format("/*+TDDL:node='%s'*/ select %s from %s;", topology.getGroupName(), ExportUtil.formatFieldWithDateType(fieldMetaInfoList), topology.getTableName());
    }

    public static String formatFieldWithDateType(List<FieldMetaInfo> fieldMetaInfoList) {
        if (fieldMetaInfoList.isEmpty()) {
            throw new IllegalArgumentException("Empty field meta info");
        }
        int fieldLen = fieldMetaInfoList.size();
        StringBuilder stringBuilder = new StringBuilder(fieldLen * 8);
        Iterator<FieldMetaInfo> iterator = fieldMetaInfoList.iterator();
        while (iterator.hasNext()) {
            FieldMetaInfo metaInfo;
            FieldMetaInfo fieldMetaInfo = metaInfo = iterator.next();
            stringBuilder.append('`').append(fieldMetaInfo.getName()).append('`');
            stringBuilder.append(',');
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    public static String getOrderBySql(TableTopology topology, List<FieldMetaInfo> fieldMetaInfoList, String columnName, boolean isAscending) {
        String orderType = isAscending ? "asc" : "desc";
        return String.format("/*+TDDL:node='%s'*/ select %s from %s order by %s " + orderType, topology.getGroupName(), ExportUtil.formatFieldWithDateType(fieldMetaInfoList), topology.getTableName(), columnName);
    }

    public static String getOrderBySql(TableTopology topology, List<FieldMetaInfo> fieldMetaInfoList, List<String> columnNameList, boolean isAscending) {
        String orderType = isAscending ? "asc" : "desc";
        return String.format("/*+TDDL:node='%s'*/ select %s from %s order by %s " + orderType, topology.getGroupName(), ExportUtil.formatFieldWithDateType(fieldMetaInfoList), topology.getTableName(), StringUtils.join(columnNameList, ","));
    }

    public static String getOrderBySql(TableTopology topology, List<FieldMetaInfo> fieldMetaInfoList, String columnName, String whereCondition, boolean isAscending) {
        if (StringUtils.isEmpty(whereCondition)) {
            return ExportUtil.getOrderBySql(topology, fieldMetaInfoList, columnName, isAscending);
        }
        String orderType = isAscending ? "asc" : "desc";
        return String.format("/*+TDDL:node='%s'*/ select %s from %s where %s order by %s " + orderType, topology.getGroupName(), ExportUtil.formatFieldWithDateType(fieldMetaInfoList), topology.getTableName(), whereCondition, columnName);
    }

    public static String getOrderBySql(TableTopology topology, List<FieldMetaInfo> fieldMetaInfoList, List<String> columnNameList, String whereCondition, boolean isAscending) {
        if (StringUtils.isEmpty(whereCondition)) {
            return ExportUtil.getOrderBySql(topology, fieldMetaInfoList, columnNameList, isAscending);
        }
        String orderType = isAscending ? "asc" : "desc";
        return String.format("/*+TDDL:node='%s'*/ select %s from %s where %s order by %s " + orderType, topology.getGroupName(), ExportUtil.formatFieldWithDateType(fieldMetaInfoList), topology.getTableName(), whereCondition, StringUtils.join(columnNameList, ","));
    }

    public static String getDirectOrderBySql(String tableName, List<FieldMetaInfo> fieldMetaInfoList, List<String> columnNameList, String whereCondition, boolean isAscending) {
        if (StringUtils.isEmpty(whereCondition)) {
            return ExportUtil.getDirectOrderBySql(tableName, fieldMetaInfoList, columnNameList, isAscending);
        }
        String orderType = isAscending ? "asc" : "desc";
        String columnNames = StringUtils.join(columnNameList, ",");
        return String.format("select %s from %s where %s order by %s " + orderType, ExportUtil.formatFieldWithDateType(fieldMetaInfoList), tableName, whereCondition, columnNames);
    }

    public static String getDirectOrderBySql(String tableName, List<FieldMetaInfo> fieldMetaInfoList, List<String> columnNameList, boolean isAscending) {
        String orderType = isAscending ? "asc" : "desc";
        String columnNames = StringUtils.join(columnNameList, ",");
        return String.format("select %s from %s order by %s " + orderType, ExportUtil.formatFieldWithDateType(fieldMetaInfoList), tableName, columnNames);
    }

    public static Comparator<OrderByExportEvent> getCombinedComparator(List<FieldMetaInfo> orderByColumnInfoList) {
        Comparator comparator = (o1, o2) -> {
            for (FieldMetaInfo fieldMetaInfo : orderByColumnInfoList) {
                int res;
                String val1 = new String(o1.getData()[fieldMetaInfo.getIndex()]);
                String val2 = new String(o2.getData()[fieldMetaInfo.getIndex()]);
                if (val1.equals("\\N")) {
                    if (val2.equals("\\N")) {
                        return 0;
                    }
                    return -1;
                }
                if (val2.equals("\\N")) {
                    return 1;
                }
                switch (fieldMetaInfo.getType()) {
                    default: {
                        res = val1.compareTo(val2);
                        break;
                    }
                    case INT: {
                        res = Integer.compare(Integer.parseInt(val1), Integer.parseInt(val2));
                        break;
                    }
                    case FLOAT: {
                        res = Double.compare(Double.parseDouble(val1), Double.parseDouble(val2));
                    }
                }
                if (res == 0) continue;
                return res;
            }
            return 0;
        };
        return comparator;
    }

    public static Comparator<ParallelOrderByExportEvent> getCombinedParallelOrderComparator(List<FieldMetaInfo> orderByColumnInfoList) {
        Comparator comparator = (o1, o2) -> {
            for (FieldMetaInfo fieldMetaInfo : orderByColumnInfoList) {
                int res;
                String val1 = new String(o1.getData()[fieldMetaInfo.getIndex()]);
                String val2 = new String(o2.getData()[fieldMetaInfo.getIndex()]);
                if (val1.equals("\\N")) {
                    if (val2.equals("\\N")) {
                        return 0;
                    }
                    return -1;
                }
                if (val2.equals("\\N")) {
                    return 1;
                }
                switch (fieldMetaInfo.getType()) {
                    default: {
                        res = val1.compareTo(val2);
                        break;
                    }
                    case INT: {
                        res = Integer.compare(Integer.parseInt(val1), Integer.parseInt(val2));
                        break;
                    }
                    case FLOAT: {
                        res = Double.compare(Double.parseDouble(val1), Double.parseDouble(val2));
                    }
                }
                if (res == 0) continue;
                return res;
            }
            return 0;
        };
        return comparator;
    }
}

