/*
 * Decompiled with CFR 0.152.
 */
package worker.util;

import exception.DatabaseException;
import java.util.List;
import model.config.GlobalVar;
import model.db.FieldMetaInfo;
import org.apache.commons.lang.StringUtils;

public class ImportUtil {
    private static final String BATCH_INSERT_SQL_PATTERN = "INSERT INTO `%s` VALUES %s;";
    private static final String BATCH_INSERT_IGNORE_SQL_PATTERN = "INSERT IGNORE INTO `%s` VALUES %s;";
    private static final String BATCH_INSERT_WITH_COL_SQL_PATTERN = "INSERT INTO `%s` (%s) VALUES %s;";
    private static final String BATCH_INSERT_IGNORE_SQL_WITH_COL_PATTERN = "INSERT IGNORE INTO `%s` (%s) VALUES %s;";
    private static final String BATCH_INSERT_HINT_SQL_PATTERN = "/*+TDDL:node='%s'*/ INSERT INTO `%s` VALUES %s;";
    private static final String BATCH_INSERT_IGNORE_HINT_SQL_PATTERN = "/*+TDDL:node='%s'*/ INSERT IGNORE INTO `%s` VALUES %s;";

    public static String getBatchInsertSql(String tableName, String values, boolean insertIgnoreEnabled) {
        if (insertIgnoreEnabled) {
            return String.format(BATCH_INSERT_IGNORE_SQL_PATTERN, tableName, values);
        }
        return String.format(BATCH_INSERT_SQL_PATTERN, tableName, values);
    }

    public static void getBatchInsertSql(StringBuilder insertSqlBuilder, String tableName, String columns, StringBuilder values, boolean insertIgnoreEnabled) {
        insertSqlBuilder.append("INSERT ");
        if (insertIgnoreEnabled) {
            insertSqlBuilder.append("IGNORE ");
        }
        insertSqlBuilder.append("INTO `").append(tableName).append("` ");
        if (columns != null) {
            insertSqlBuilder.append('(').append(columns).append(") ");
        }
        insertSqlBuilder.append("VALUES ").append((CharSequence)values).append(";");
    }

    public static void appendInsertStrValue(StringBuilder sqlStringBuilder, String rawValue, boolean sqlEscapeEnabled, boolean hasEscapedQuote) {
        if (rawValue.equals("\\N")) {
            sqlStringBuilder.append("NULL");
            return;
        }
        if (GlobalVar.IN_PERF_MODE) {
            sqlStringBuilder.append(rawValue);
            return;
        }
        if (sqlEscapeEnabled) {
            sqlStringBuilder.append("'").append(ImportUtil.escapeSqlSpecialChar(rawValue)).append("'");
        } else {
            sqlStringBuilder.append("'").append(rawValue).append("'");
        }
    }

    private static String escapeSqlSpecialChar(String sqlValue) {
        if (!StringUtils.isEmpty(sqlValue)) {
            sqlValue = sqlValue.replaceAll("\\\\", "\\\\\\\\").replaceAll("\b", "\\\\b").replaceAll("\n", "\\\\n").replaceAll("\r", "\\\\r").replaceAll("\t", "\\\\t").replaceAll("\\x1A", "\\\\Z").replaceAll("\\x00", "\\\\0").replaceAll("'", "\\\\'").replaceAll("\"", "\\\\\"");
        }
        return sqlValue;
    }

    public static void appendInsertNonStrValue(StringBuilder sqlStringBuilder, String rawValue, boolean hasEscapedQuote) {
        if (rawValue.equals("\\N")) {
            sqlStringBuilder.append("NULL");
        } else {
            sqlStringBuilder.append(rawValue);
        }
    }

    public static void appendValuesByFieldMetaInfo(StringBuilder stringBuilder, List<FieldMetaInfo> fieldMetaInfoList, List<String> values, boolean sqlEscapeEnabled, boolean hasEscapedQuote) throws DatabaseException {
        if (fieldMetaInfoList.size() != values.size()) {
            throw new DatabaseException(String.format("required field size %d, actual size %d", fieldMetaInfoList.size(), values.size()));
        }
        int fieldLen = fieldMetaInfoList.size();
        for (int i = 0; i < fieldLen - 1; ++i) {
            if (fieldMetaInfoList.get(i).needQuote()) {
                ImportUtil.appendInsertStrValue(stringBuilder, values.get(i), sqlEscapeEnabled, hasEscapedQuote);
            } else {
                ImportUtil.appendInsertNonStrValue(stringBuilder, values.get(i), hasEscapedQuote);
            }
            stringBuilder.append(",");
        }
        if (fieldMetaInfoList.get(fieldLen - 1).needQuote()) {
            ImportUtil.appendInsertStrValue(stringBuilder, values.get(fieldLen - 1), sqlEscapeEnabled, hasEscapedQuote);
        } else {
            ImportUtil.appendInsertNonStrValue(stringBuilder, values.get(fieldLen - 1), hasEscapedQuote);
        }
    }

    public static void getDirectImportSql(StringBuilder stringBuilder, String tableName, List<FieldMetaInfo> fieldMetaInfoList, List<String> values, boolean sqlEscapeEnabled, boolean hasEscapedQuote) throws DatabaseException {
        stringBuilder.append("INSERT INTO `").append(tableName).append("` VALUES (");
        ImportUtil.appendValuesByFieldMetaInfo(stringBuilder, fieldMetaInfoList, values, sqlEscapeEnabled, hasEscapedQuote);
        stringBuilder.append(");");
    }

    public static String getBatchInsertSqlWithHint(String nodeName, String tableName, String data, boolean insertIgnoreEnabled) {
        if (insertIgnoreEnabled) {
            return String.format(BATCH_INSERT_IGNORE_HINT_SQL_PATTERN, nodeName, tableName, data);
        }
        return String.format(BATCH_INSERT_HINT_SQL_PATTERN, nodeName, tableName, data);
    }
}

