/*
 * Decompiled with CFR 0.152.
 */
package worker.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import model.db.FieldMetaInfo;
import model.db.PrimaryKey;
import model.db.TableFieldMetaInfo;
import org.apache.commons.lang.StringUtils;
import util.DbUtil;

public class UpdateUtil {
    private static final String BATCH_REPLACE_PATTERN_WITH_HINT = "/*+TDDL:node='%s'*/ REPLACE INTO `%s`(%s) VALUES %s;";
    private static final String BATCH_REPLACE_PATTERN = " REPLACE INTO `%s`(%s) VALUES %s;";

    public static String getPreparedUpdateSql(String tableName, TableFieldMetaInfo tableFieldMetaInfo) {
        String sqlPattern = "UPDATE `%s` SET %s WHERE %s;";
        String wherePk = tableFieldMetaInfo.getPrimaryKey().getName() + "=?";
        String update = UpdateUtil.formatTableFieldWithPlaceholder(tableFieldMetaInfo);
        return String.format(sqlPattern, tableName, update, wherePk);
    }

    public static String getPreparedUpdateSql(String tableName, TableFieldMetaInfo tableFieldMetaInfo, String whereCondition) {
        if (StringUtils.isEmpty(whereCondition)) {
            return UpdateUtil.getPreparedUpdateSql(tableName, tableFieldMetaInfo);
        }
        String sqlPattern = "UPDATE `%s` SET %s WHERE %s AND %s;";
        String wherePk = tableFieldMetaInfo.getPrimaryKey().getName() + "=?";
        String update = UpdateUtil.formatTableFieldWithPlaceholder(tableFieldMetaInfo);
        return String.format(sqlPattern, tableName, update, wherePk, whereCondition);
    }

    public static String formatToReplaceColumns(TableFieldMetaInfo tableFieldMetaInfo) {
        List<FieldMetaInfo> fieldMetaInfoList = tableFieldMetaInfo.getFieldMetaInfoList();
        StringBuilder stringBuilder = new StringBuilder(fieldMetaInfoList.size() * 8);
        for (int i = 0; i < fieldMetaInfoList.size() - 1; ++i) {
            stringBuilder.append(fieldMetaInfoList.get(i).getName()).append(",");
        }
        stringBuilder.append(fieldMetaInfoList.get(fieldMetaInfoList.size() - 1).getName());
        return stringBuilder.toString();
    }

    public static String getBatchReplaceSqlWithHint(String nodeName, String tableName, String toReplaceColumns, String data) {
        return String.format(BATCH_REPLACE_PATTERN_WITH_HINT, nodeName, tableName, toReplaceColumns, data);
    }

    public static String getBatchReplaceSql(String tableName, String toReplaceColumns, String data) {
        return String.format(BATCH_REPLACE_PATTERN, tableName, toReplaceColumns, data);
    }

    public static String getUpdatedValuesByMetaInfo(Set<Integer> pkIndexSet, List<String> values, List<FieldMetaInfo> fieldMetaInfoList) {
        ArrayList<String> updatedValueList = new ArrayList<String>(fieldMetaInfoList.size());
        block5: for (FieldMetaInfo fieldMetaInfo : fieldMetaInfoList) {
            String fieldValue = values.get(fieldMetaInfo.getIndex());
            if (pkIndexSet.contains(fieldMetaInfo.getIndex())) {
                if (fieldMetaInfo.getType() == FieldMetaInfo.Type.STRING) {
                    updatedValueList.add("'" + fieldValue + "'");
                    continue;
                }
                updatedValueList.add(fieldValue);
                continue;
            }
            if (fieldValue.equals("\\N")) {
                updatedValueList.add("NULL");
                continue;
            }
            switch (fieldMetaInfo.getType()) {
                case STRING: {
                    updatedValueList.add("'" + StringUtils.reverse(fieldValue) + "'");
                    continue block5;
                }
                case INT: {
                    int fieldIntValue = Integer.parseInt(fieldValue);
                    updatedValueList.add(String.valueOf(fieldIntValue * 2));
                    continue block5;
                }
                case FLOAT: {
                    float fieldFloatValue = Float.parseFloat(fieldValue);
                    updatedValueList.add(String.valueOf(fieldFloatValue * 2.0f));
                    continue block5;
                }
            }
            updatedValueList.add("'" + fieldValue + "'");
        }
        return StringUtils.join(updatedValueList, ",");
    }

    private static String formatTableFieldWithPlaceholder(TableFieldMetaInfo tableFieldMetaInfo) {
        int fieldLen = tableFieldMetaInfo.getFieldMetaInfoList().size();
        int pkIndex = tableFieldMetaInfo.getPrimaryKey().getOrdinalPosition() - 1;
        Object[] updateFields = new String[fieldLen - 1];
        int i = 0;
        int j = 0;
        while (i < fieldLen) {
            if (i != pkIndex) {
                updateFields[j] = tableFieldMetaInfo.getFieldMetaInfoList().get(i).getName() + "=?";
            } else {
                --j;
            }
            ++i;
            ++j;
        }
        return StringUtils.join(updateFields, ",");
    }

    public static String getUpdateSql(String tableName, List<PrimaryKey> pkList, Set<Integer> pkIndexSet, List<FieldMetaInfo> fieldMetaInfoList, List<String> values, String where) {
        if (StringUtils.isEmpty(where)) {
            return UpdateUtil.getUpdateSql(tableName, pkList, pkIndexSet, fieldMetaInfoList, values);
        }
        String updateSqlPattern = "UPDATE %s SET %s WHERE %s AND %s;";
        String pkCondition = DbUtil.formatPkConditions(pkList, values);
        String setUpdatedValue = UpdateUtil.formatSetUpdatedValues(pkIndexSet, fieldMetaInfoList, values);
        return String.format(updateSqlPattern, tableName, setUpdatedValue, pkCondition, where);
    }

    public static String getUpdateSql(String tableName, List<PrimaryKey> pkList, Set<Integer> pkIndexSet, List<FieldMetaInfo> fieldMetaInfoList, List<String> values) {
        String updateSqlPattern = "UPDATE %s SET %s WHERE %s;";
        String pkCondition = DbUtil.formatPkConditions(pkList, values);
        String setUpdatedValue = UpdateUtil.formatSetUpdatedValues(pkIndexSet, fieldMetaInfoList, values);
        return String.format(updateSqlPattern, tableName, setUpdatedValue, pkCondition);
    }

    public static String formatSetUpdatedValues(Set<Integer> pkIndexSet, List<FieldMetaInfo> fieldMetaInfoList, List<String> values) {
        ArrayList<String> updatedValueList = new ArrayList<String>(fieldMetaInfoList.size() - pkIndexSet.size());
        for (FieldMetaInfo fieldMetaInfo : fieldMetaInfoList) {
            String fieldValue = values.get(fieldMetaInfo.getIndex());
            if (pkIndexSet.contains(fieldMetaInfo.getIndex())) continue;
            if (fieldValue.equals("\\N")) {
                updatedValueList.add(fieldMetaInfo.getName() + "=" + "NULL");
                continue;
            }
            switch (fieldMetaInfo.getType()) {
                case STRING: {
                    updatedValueList.add(fieldMetaInfo.getName() + "='" + StringUtils.reverse(fieldValue) + "'");
                    break;
                }
                case INT: {
                    int fieldIntValue = Integer.parseInt(fieldValue);
                    updatedValueList.add(fieldMetaInfo.getName() + "=" + fieldIntValue * 2);
                    break;
                }
                case FLOAT: {
                    float fieldFloatValue = Float.parseFloat(fieldValue);
                    updatedValueList.add(fieldMetaInfo.getName() + "=" + fieldFloatValue * 2.0f);
                    break;
                }
            }
        }
        return StringUtils.join(updatedValueList, ",");
    }

    public static String getUpdateWithFuncSql(String updateWithFuncPattern, List<PrimaryKey> pkList, List<String> pkValues) {
        String pkCondition = DbUtil.formatPkConditions(pkList, pkValues);
        return String.format(updateWithFuncPattern, pkCondition);
    }

    public static String getUpdateWithFuncInSql(String updateWithFuncPattern, String pkNames, String inPkValues) {
        String pkInCondition = String.format("(%s) in (%s)", pkNames, inPkValues);
        return String.format(updateWithFuncPattern, pkInCondition);
    }

    public static String getUpdateWithFuncSqlPattern(String tableName, List<FieldMetaInfo> fieldMetaInfoList, Set<Integer> pkIndexSet) {
        String basePattern = "UPDATE %s SET %s WHERE";
        String updateWithFunc = UpdateUtil.getUpdateFunction(fieldMetaInfoList, pkIndexSet);
        String formattedPattern = String.format(basePattern, tableName, updateWithFunc);
        return formattedPattern + " %s;";
    }

    private static String getUpdateFunction(List<FieldMetaInfo> fieldMetaInfoList, Set<Integer> pkIndexSet) {
        ArrayList<String> updatedValueList = new ArrayList<String>(fieldMetaInfoList.size() - pkIndexSet.size());
        for (FieldMetaInfo fieldMetaInfo : fieldMetaInfoList) {
            if (pkIndexSet.contains(fieldMetaInfo.getIndex())) continue;
            switch (fieldMetaInfo.getType()) {
                case STRING: {
                    updatedValueList.add(fieldMetaInfo.getName() + "=REVERSE(" + fieldMetaInfo.getName() + ")");
                    break;
                }
                case INT: 
                case FLOAT: {
                    updatedValueList.add(fieldMetaInfo.getName() + "=2*" + fieldMetaInfo.getName());
                    break;
                }
            }
        }
        return StringUtils.join(updatedValueList, ",");
    }
}

