# TPC-H 测试

- [TPC-H 测试](#tpc-h-测试)
  - [数据生成与导入](#数据生成与导入)
    - [建表](#建表)
    - [数据生成](#数据生成)
    - [数据导入](#数据导入)
  - [执行查询与调优](#执行查询与调优)
    - [执行查询](#执行查询)
    - [基准数据](#基准数据)
    - [调优实践](#调优实践)
    - [备注](#备注)

首先在根目录下的`conn-params.conf`文件中填入PolarDB-X实例对应的连接信息。

## 数据生成与导入

### 建表
在命令行连接上PolarDB-X集群，并use对应的库，执行以下命令

- **DRDS模式**：`source ddl/tpch-drds-ddl.sql`

- **AUTO模式**：`source ddl/tpch-auto-ddl.sql`

### 数据生成
1. 进入`tpch-data/datagen`目录下，执行 `sh generateTPCH.sh 100` 生成100GB的数据集（同理，生成1TB数据则执行 `sh generateTPCH.sh 1000`）

    > 如果当前为非x86平台，需进入 `tpch-data/datagen/dbgen-src/` 目录下，执行 `make` 命令生成二进制可执行文件，替换 `../dbgen` 文件
    
    > 如果要生成其他规模的数据集，如5GB/20GB， 需要在`tpch-data/workloads`路径下执行`cp tpch.workload.10.lst tpch.workload.{数据量}.lst`，其文件内容分为三列，分别为：表名缩写、表名、切分文件数（必要时可手动改大切分文件数来加速后续导入）

2. 等待后台生成数据进程运行结束，执行 `ls -lh tpch-data/tpch/tpchRaw/SF100/*` 查看生成的数据文件

   > 通过执行`ls`命令，看到当前目录下没有 tbl 临时数据文件，即生成数据完成

> 生成数据耗时参考：
> 
> 客户端 32C128G，顺序写入速度 200MB/s
> 
> 生成100GB数据，耗时在8.5分钟左右

### 数据导入

可以使用 load data 导入或者 batch-tool 导入

**load data**

1. 编辑 `tpch-data/params.conf` 配置文件，填入连接串参数
2. 进入`tpch-data/loadTpch`目录下，执行 `sh loadTpch.sh 100` 导入100GB的数据

**batch-tool**

下载地址：https://github.com/ApsaraDB/galaxysql-tools/releases/

TPC-H 100GB 调优后的命令如下（客户端机器16C32G，PolarDB-X 2 * 16C64G，耗时约45min）：
```shell
java -Xmn10g -Xmx16g -jar batch-tool.jar -h "{HOST}" -P3306 -uroot -p "{PASSWORD}" -D "tpch_drds" -o import -s '|' -t "region" -dir "region" -quote none -noesc -batchsize 100 -lastSep

java -Xmn10g -Xmx16g -jar batch-tool.jar -h "{HOST}" -P3306 -uroot -p "{PASSWORD}" -D "tpch_drds" -o import -s '|' -t "nation" -dir "nation" -quote none -noesc -batchsize 100 -lastSep

java -Xmn10g -Xmx16g -jar batch-tool.jar -h "{HOST}" -P3306 -uroot -p "{PASSWORD}" -D "tpch_drds" -o import -s '|' -t "part" -dir "part" -quote none -noesc -batchsize 100 -lastSep -pro 6 -con 40

java -Xmn10g -Xmx16g -jar batch-tool.jar -h "{HOST}" -P3306 -uroot -p "{PASSWORD}" -D "tpch_drds" -o import -s '|' -t "partsupp" -dir "partsupp" -quote none -noesc -batchsize 100 -lastSep -pro 6 -con 40

java -Xmn10g -Xmx16g -jar batch-tool.jar -h "{HOST}" -P3306 -uroot -p "{PASSWORD}" -D "tpch_drds" -o import -s '|' -t "supplier" -dir "supplier" -quote none -noesc -batchsize 100 -lastSep -pro 6 -con 40

java -Xmn10g -Xmx16g -jar batch-tool.jar -h "{HOST}" -P3306 -uroot -p "{PASSWORD}" -D "tpch_drds" -o import -s '|' -t "customer" -dir "customer" -quote none -noesc -batchsize 100 -lastSep -pro 6 -con 40

nohup java -Xmn10g -Xmx16g -jar batch-tool.jar -h "{HOST}" -P3306 -uroot -p "{PASSWORD}" -D "tpch_drds" -o import -s '|' -t "orders" -dir "orders" -quote none -noesc -batchsize 100 -lastSep -pro 8 -con 50 &

nohup java -Xmn10g -Xmx16g -jar batch-tool.jar -h "{HOST}" -P3306 -uroot -p "{PASSWORD}" -D "tpch_drds" -o import -s '|' -t "lineitem" -dir "lineitem" -quote none -noesc -batchsize 100 -lastSep -pro 8 -con 50 &
```


## 执行查询与调优

执行如下命令采集表的统计信息：
```sql
analyze table customer;
analyze table lineitem;
analyze table nation;
analyze table orders;
analyze table part;
analyze table partsupp;
analyze table region;
analyze table supplier;
```

### 执行查询

进入 `tpch-queries/` 目录，执行 `sh all_query.sh`

### 基准数据


TPCH-100G | 8c64g * 6| 16c128g * 6
---------|----------|---------
Q1 |   	47.5 |	26.06
Q2 |    1.71 |	1.29
Q3|    	10.48 |	5.63
Q4|    	2.86 |	1.61
Q5|    	7.49 |	4.09
Q6|    	8.77 |	4.62
Q7|    	18.56 |	10.09
Q8|    	8.63	 |4.87
Q9|    	41.89 |	21.75
Q10|    5.65 |	3.59
Q11|    3.5 |	2.21
Q12|    10.31 |	5.56
Q13|    4.78 |	2.54
Q14|    9.84 |	5.14
Q15|    17.53 |	9.12
Q16|    1.62 |	1.2
Q17|    2.06 |	1.69
Q18|    13.39 |	6.82
Q19|    2.43	 |1.77
Q20|    11.05	 |5.86
Q21|    44.07 |	23.05
Q22|    3.24 |	1.94
总时间|  273.86 |	148.29


### 调优实践

1. 跑TPCH的场景下，建议调大并行度，但是并行度会受限与分表数量，所以建表的时候建议把TPCH的分表数量大于所有DN的CPU Core总和；
2. 默认在主实例上关闭MPP，要开打的话需要配置ENABLE_MASTER_MPP=true；
3. 默认关闭follower read能力，打开后，还需要配置follower和leader的读写比例，建议配置MASTER_READ_WEIGHT=50;
4. 优化器基于统计信息尽量会把sort下推，但是sort下推后可能会影响到并发度，因为sort是全局有序，并发度为1。所以这里建议关闭sort下推
   ENABLE_PASS_THROUGH_TRAIT=false 和 ENABLE_DERIVE_TRAIT=false (设置后，可能会清理下plan cache)
5. 并行度的配置，建议为所有CN的CPU core总和。PARALLELISM=xx MPP_PARALLELISM=xx
6. 为了避免并行度太大，我们默认情况下会基于CN和DN的CPU core限制并行度，在性能测试场景下，可以放开这个配置，相关配置项是
   POLARDBX_PARALLELISM（可以考虑调整到128）
7. 默认单条查询最多只能用一半的CN内存，为了避免大查询受内存限制报错，可以调大PER_QUERY_MEMORY_LIMIT 参数，建议调成和show memorypool 一样的数值

8. 为15.sql调大bka join batch size大小，且为lineitem列l_shipdate加索引
   
   经过上述配置后，可以使用 `explain physical` 查看sql的真实并行度。 这里总结起来Metadb的配置如下:

```sql
TRANSACTION_POLICY=XA
ENABLE_MASTER_MPP=true
MASTER_READ_WEIGHT=50
ENABLE_PASS_THROUGH_TRAIT=false
ENABLE_DERIVE_TRAIT=false
PARALLELISM=xx 
MPP_PARALLELISM=xx
DATABASE_PARALLELISM=128
```

   跑完TPCH后，建议恢复实例状态，避免干扰到对TP场景的性能测试.关闭follwer read和开启协程，且重置metadb的配置:

```sql
TRANSACTION_POLICY=TSO
ENABLE_MASTER_MPP=false
MASTER_READ_WEIGHT=100
ENABLE_PASS_THROUGH_TRAIT=true
ENABLE_DERIVE_TRAIT=true
PARALLELISM=-1
MPP_PARALLELISM=-1
DATABASE_PARALLELISM=-1
```


### 备注
1. MPP模式下，ajdk协程调度可能存在bug，导致执行 TPC-H 查询卡住.建议关闭协程.（需要重启）

```aidl
echo 'wisp=nowisp' >> /home/admin/drds-server/env/config.properties; 
```
2. 在性能测试下，XDB三节点,默认参与计算的是leader节点，follower节点是浪费的，为了让follower参与计算，建议开启follwer read能力（需要重启）

```aidl
echo 'supportSlaveRead=true' >> /home/admin/drds-server/env/config.properties; 
```
确保上述两个配置在所有CN节点配置成功后，重启CN。