#!/bin/bash

if [ ! $# -eq 1 ] ; then
    echo "usage: $(basename $0) cpu_cores" >&2
    exit 1
fi

home_dir=$(dirname $(dirname "$PWD"))
sed -i "16c export targetPath=$home_dir/benchmark-boot-data/tpch" params.conf

cpu_cores=$(cat /proc/cpuinfo| grep "processor"| wc -l)

if [ $1 -le 0 ] ; then
    sed -i "24c #export threadsPerWorker=1" params.conf
elif [ $cpu_cores  -ge $1 ] ; then
    sed -i "24c export threadsPerWorker=$1" params.conf
else
    sed -i "24c #export threadsPerWorker=1" params.conf
fi