#!/bin/bash
##############################################################################
# TPCH Raw Data Generation 
##############################################################################
set -eu
source ../params.conf

### Check for workload -- a file with one row for a tpc-h table, each row with format <tblCode> <tblName> <#Chunks>
## Assume that all the nodes are uniformi. If no existing workload file is found, will generate one now -

if [ $# -lt 1 ]; then
	echo "[ERROR] Insufficient # of params"
	echo "USAGE: `dirname $0`/$0 <scaleFactor>"
	exit 127
fi

scaleFactor=$1

workFile=../workloads/tpch.workload.${scaleFactor}.lst

#Clear existing workloads
rm -rf loadData.sh

### Init Workloads
fileName=loadData.sh
echo "#!/bin/bash" >> $fileName
echo "  "  >> $fileName
echo "workDir=\`dirname \$0\`"  >> $fileName
echo "cd \$workDir"  >> $fileName
echo "source ../params.conf"  >> $fileName
echo "  "  >> $fileName

workDir=`dirname $0`
### Generate Workloads
while read line; do
	params=( $line )
	#Extracting Parameters
	#echo ${params[*]}
	tblCode=${params[0]}
	tblName=${params[1]}
	tblParts=${params[2]}
	echo "====$tblName==="
	mkdir -p ${targetPath}/SF${scaleFactor}/$tblName
	# Assigning workload in round-robin fashion
	partsDone=1
        $insertMysql  "truncate table $tblName"
	while [ $partsDone -le $tblParts ]; do
		#echo "write part $partsDone of $tblParts for $tblName (dbgen : $tblCode) on HostID="$worker
		if [ $tblParts -gt 1 ]; then
			echo "$insertMysql \" ${hint}LOAD DATA LOCAL INFILE '${targetPath}/SF${scaleFactor}/$tblName/${tblName}_${partsDone}' INTO TABLE $tblName FIELDS TERMINATED BY '|' LINES TERMINATED BY '|\\n';\" &" >> loadData.sh
		else
			echo "$insertMysql \" ${hint}LOAD DATA LOCAL INFILE '${targetPath}/SF${scaleFactor}/$tblName/${tblName}_1' INTO TABLE $tblName FIELDS TERMINATED BY '|' LINES TERMINATED BY '|\\n';\" &" >> loadData.sh
		fi
		echo "${workDir}/wait4process.sh local-infile \$threadsPerWorker " >> loadData.sh
		echo "   " >> loadData.sh

		let partsDone=1+$partsDone
	done
done <$workFile;


echo "[INFO] Started Generation @ "`date +%H:%M:%S`
startTime=`date +%s`

### Distribute & Execute workloads

chmod 755 loadData.sh
sh loadData.sh &


### Waiting for completion
echo "[INFO] Waiting until completion..."
wait
endTime=`date +%s`
echo "[INFO] Completed Generation @ "`date +%H:%M:%S`
echo "[INFO] Generated and loaded SF"${scaleFactor}" in "`echo $endTime - $startTime |bc`" sec"
