#!/bin/bash
set -e
if [ ! $# -eq 1 ] ; then
    echo "usage: $(basename $0) scaleFactor" >&2
    exit 1
fi

configPath="../../tpch/conn-params.conf"
source "../../tpch/tpch-data/params.conf"
scaleFactor=$1
dataDirPrefix="../tpch/SF${scaleFactor}"

if [ -z $threadsPerWorker ]; then
	threadsPerWorker=8
fi

# available
freecount=`free -m | grep 'Mem' |awk '{print $7}'`
cgroupfile="/sys/fs/cgroup/memory/memory.limit_in_bytes"
cgroupcount=0
if [ -e "$cgroupfile" ]; then
    cgroupcount=$(cat "$cgroupfile" | awk '{printf int($1/1024/1024)}')
fi
if [ $cgroupcount -ne 0 ] && [ $cgroupcount -lt $freecount ]; then
    freecount=$cgroupcount
fi
if [ x"$freecount" == "x" ]; then
  JAVA_OPTS=" "
else
  if [ $freecount -le 2048 ]; then
      echo "free memory less than 2g" >&2
      exit 1
  fi

  if [ $freecount -ge 131072 ] ; then
    JAVA_OPTS="-Xmn40g -Xms60g -Xmx60g "

  elif [ $freecount -ge 65536 ]; then
     JAVA_OPTS="-Xmn32g -Xms40g -Xmx40g "
  elif [ $freecount -ge 32768 ]; then
     JAVA_OPTS="-Xmn16g -Xms22g -Xmx22g "
  elif [ $freecount -ge 16384 ]; then
     JAVA_OPTS="-Xmn10g -Xms14g -Xmx14g "
  elif [ $freecount -ge 8192 ]; then
     JAVA_OPTS="-Xmn6g -Xms8g -Xmx8g " 
  elif [ $freecount -ge 4096 ]; then
     JAVA_OPTS="-Xmn2g -Xms4g -Xmx4g " 
  else
    JAVA_OPTS="-Xmn1g -Xms2g -Xmx2g "
  fi
fi
JAVA_OPTS="$JAVA_OPTS -XX:+UseG1GC "

if [ "${loadBalance}" = "" ]; then
  basic_opts="-h \"${host}\" -P \"${port}\" -u \"${user}\" -p \"${password}\" -D \"${db}\" -o import -s \"|\" "
else
  basic_opts="-h \"${loadBalance}\" -lb -u \"${user}\" -p \"${password}\" -D \"${db}\" -o import -s \"|\" "
fi

if [ $threadsPerWorker -le 2 ] ; then
  java ${JAVA_OPTS} -jar batch-tool.jar ${basic_opts} -benchmark tpch -scale ${scaleFactor} -pro 1 -con 50 -ringsize 4096 -minConn 51 -maxConn 56 -batchSize 200
elif [ $threadsPerWorker -le 4 ] ; then
  java ${JAVA_OPTS} -jar batch-tool.jar ${basic_opts} -benchmark tpch -scale ${scaleFactor} -pro 1 -con 100 -ringsize 4096 -minConn 101 -maxConn 110 -batchSize 300
else
  java ${JAVA_OPTS} -jar batch-tool.jar ${basic_opts} -benchmark tpch -scale ${scaleFactor} -pro 2 -con 200 -ringsize 8192 -minConn 201 -maxConn 210 -batchSize 500
fi
