#!/bin/bash

if [ $# -lt 4 ] ; then
    echo "usage: $(basename $0) PROPS warehouses loadWorkers mode [partitions] [startWarehouse] [endWarehouse]" >&2
    exit 1
fi

if [ $4 == 'DRDS' ] || [ $4 == 'drds' ] ; then
  cp -f sql.common/tableCreates-drds.sql sql.common/tableCreates.sql
elif [ $4 == 'AUTO' ] || [ $4 == 'auto' ] ; then
  cp -f sql.common/tableCreates-auto.sql sql.common/tableCreates.sql
  if [ $# -ge 5 ] ; then
    sed -i "/PARTITIONS/c \ \ PARTITIONS $5;" sql.common/tableCreates.sql
  fi
elif [ $4 == 'MYSQL' ] || [ $4 == 'mysql' ] ; then
  cp -f sql.common/tableCreates-mysql.sql sql.common/tableCreates.sql
else
  echo "Unknown mode: $4" >&2
  exit 1
fi

sed -i "/warehouses/c warehouses=$2" $1
sed -i "/loadWorkers/c loadWorkers=$3" $1

sed -i "/startWarehouse/d" $1
sed -i "/endWarehouse/d" $1

if [ $# -ge 6 ] ; then
  sed -i "\$a startWarehouse=$6" $1
fi
if [ $# -ge 7 ] ; then
    sed -i "\$a endWarehouse=$7" $1
fi