#!/bin/bash

if [ $# -lt 1 ] ; then
    echo "usage: $(basename $0) my_result_xxx " >&2
    exit 1
fi

dir=$1
total_time=$(cat $dir/data/result.csv| awk -F ',' '{if (NR>1){sum1+=$4}} END{print sum1}')

neworder_total=$(cat $dir/data/result.csv|grep NEW_ORDER | awk -F ',' '{if (NR>1){sum1+=$4}} END{print sum1}')
neworder_line=$(cat $dir/data/result.csv|grep NEW_ORDER|wc -l)
neworder_avg=$(echo "scale=4;$neworder_total / $neworder_line"|bc)
neworder_per=$(echo "scale=4;$neworder_total / $total_time * 100"|bc)

payment_total=$(cat $dir/data/result.csv|grep PAYMENT | awk -F ',' '{if (NR>1){sum1+=$4}} END{print sum1}')
payment_line=$(cat $dir/data/result.csv|grep PAYMENT|wc -l)
payment_avg=$(echo "scale=4;$payment_total / $payment_line"|bc)
payment_per=$(echo "scale=4;$payment_total / $total_time * 100"|bc)

orderstatus_total=$(cat $dir/data/result.csv|grep ORDER_STATUS | awk -F ',' '{if (NR>1){sum1+=$4}} END{print sum1}')
orderstatus_line=$(cat $dir/data/result.csv|grep ORDER_STATUS|wc -l)
orderstatus_avg=$(echo "scale=4;$orderstatus_total / $orderstatus_line"|bc)
orderstatus_per=$(echo "scale=4;$orderstatus_total / $total_time * 100"|bc)

stocklevel_total=$(cat $dir/data/result.csv|grep STOCK_LEVEL| awk -F ',' '{if (NR>1){sum1+=$4}} END{print sum1}')
stocklevel_line=$(cat $dir/data/result.csv|grep STOCK_LEVEL|wc -l)
stocklevel_avg=`expr $stocklevel_total / $stocklevel_line`
stocklevel_per=`expr $stocklevel_total / $total_time \* 100`
stocklevel_avg=$(echo "scale=4;$stocklevel_total / $stocklevel_line"|bc)
stocklevel_per=$(echo "scale=4;$stocklevel_total / $total_time * 100"|bc)

deliverybg_total=$(cat $dir/data/result.csv|grep DELIVERY_BG | awk -F ',' '{if (NR>1){sum1+=$4}} END{print sum1}')
deliverybg_line=$(cat $dir/data/result.csv|grep DELIVERY_BG|wc -l)
deliverybg_avg=$(echo "scale=4;$deliverybg_total / $deliverybg_line"|bc)
deliverybg_per=$(echo "scale=4;$deliverybg_total / $total_time * 100"|bc)

echo "NEW_ORDER avg time: $neworder_avg ms , total time: $neworder_total ms, total calls: $neworder_line, percent: $neworder_per %"
echo "PAYMENT avg time: $payment_avg ms , total time: $payment_total ms, total calls: $payment_line, percent: $payment_per %"
echo "ORDER_STATUS avg time: $orderstatus_avg ms , total time: $orderstatus_total ms, total calls: $orderstatus_line, percent: $orderstatus_per %"
echo "STOCK_LEVEL avg time: $stocklevel_avg ms , total time: $stocklevel_total ms, total calls: $stocklevel_line, percent: $stocklevel_per %"
echo "DELIVERY_BG avg time: $deliverybg_avg ms , total time: $deliverybg_total ms, total calls: $deliverybg_line, percent: $deliverybg_per %"