#!/usr/bin/env bash

if [ $# -lt 1 ] ; then
    echo "usage: $(basename $0) PROPS_FILE [ARGS]" >&2
    exit 2
fi

source funcs.sh $1
shift

setCP || exit 1

# available
freecount=`free -m | grep 'Mem' |awk '{print $7}'`
cgroupfile="/sys/fs/cgroup/memory/memory.limit_in_bytes"
cgroupcount=0
if [ -e "$cgroupfile" ]; then
    cgroupcount=$(cat "$cgroupfile" | awk '{printf int($1/1024/1024)}')
fi
if [ $cgroupcount -ne 0 ] && [ $cgroupcount -lt $freecount ]; then
    freecount=$cgroupcount
fi
if [ x"$freecount" == "x" ]; then
  JAVA_OPTS=" "
else
  if [ $freecount -le 2048 ]; then
      echo "free memory less than 2g" >&2
      exit 1
  fi

  if [ $freecount -ge 131072 ] ; then
    JAVA_OPTS="-Xmn60g -Xms80g -Xmx80g "
  elif [ $freecount -le 4096 ] ; then
    JAVA_OPTS="-Xmn1g -Xms2g -Xmx2g "
  elif [ $freecount -ge 65536 ]; then
     heap=`echo $freecount | awk '{print int($1 / 1024 * 0.6)}'`
     new_gen=`echo $heap | awk '{print int($1 * 0.6)}'`

     JAVA_OPTS="-Xmn${new_gen}g -Xms${heap}g -Xmx${heap}g "
  else
    heap=`echo $freecount | awk '{print int(($1 / 1024 + 1) * 0.7)}'`
    new_gen=`echo $heap | awk '{print int($1 * 0.6)}'`

    JAVA_OPTS="-Xmn${new_gen}g -Xms${heap}g -Xmx${heap}g "
  fi
fi

JAVA_OPTS="$JAVA_OPTS -XX:+UseG1GC "
java -server $JAVA_OPTS -cp "$myCP" -Dprop=$PROPS LoadData $*

status=$?
exit $status