DROP PROCEDURE IF EXISTS new_order_tpcc;
-- do not delete separator

-- new order
CREATE PROCEDURE new_order_tpcc(
    in param_w_id int ,
    in param_d_id int,
    in param_c_id int,
    in param_o_ol_cnt int,
    in param_o_all_local int,
    in param_itemid varchar(512),   -- Encoding for item id: concat_ws(“,”, item1, item2, ...)
    in param_supware varchar(512),  -- Encoding for item warehouse: concat_ws(“,”, warehouse1, ...)
    in param_qyt varchar(512))       -- Encoding for item qty: concat_ws(“,”, q1, q2, ...)
    label:begin

    -- declare variables
    declare var_ol_number int default 1; -- cycles
    declare var_i_price decimal(5,2) default NULL;
    declare var_i_name varchar(24) default NULL;
    declare var_i_data varchar(50) default NULL;
    declare var_s_quantity smallint default NULL;
    declare var_s_data varchar(50) default NULL;
    declare var_ol_dist_info varchar(24) default NULL;
    declare var_bg varchar(2) default NULL;
    declare var_ol_amount decimal(6,2) default NULL;
    declare var_ol_supply_w_id int default NULL; -- item warehouse
    declare var_ol_i_id int default NULL;        -- item id
    declare var_ol_quantity int default NULL;    -- item qty
    declare var_remote int default NULL; -- item is remote supply

    declare err int;
    declare n_var_datetime char(81);
    declare n_var_c_last varchar(16);
    declare n_var_c_credit char(2);
    declare n_var_c_discount decimal(4,2);
    declare n_var_d_next_o_id int;
    declare n_var_w_tax decimal(4,2);
    declare n_var_d_tax decimal(4,2);
    declare n_var_amount_total decimal(8,2);
    declare n_item_data text(501);

    -- defining error handling
    -- declare continue HANDLER FOR SQLWARNING,NOT FOUND,SQLEXCEPTION
    declare exit HANDLER FOR NOT FOUND
begin
      set err = -1;
select err,n_item_data,n_var_amount_total,n_var_c_credit,n_var_c_discount,n_var_c_last,n_var_d_next_o_id,n_var_d_tax,n_var_datetime,n_var_w_tax;
rollback;
end;
START TRANSACTION;
set err = 0;

select CURRENT_TIMESTAMP() into n_var_datetime;
set n_var_amount_total=0;

    -- query the user's discount, tax and so on
    SELECT c_discount, c_last, c_credit, w_tax INTO n_var_c_discount, n_var_c_last, n_var_c_credit, n_var_w_tax
    FROM bmsql_customer, bmsql_warehouse
    WHERE w_id = param_w_id AND c_w_id = w_id AND c_d_id = param_d_id AND c_id = param_c_id;

    -- polarx replace returning
    select d_next_o_id,d_tax from bmsql_district WHERE d_id = param_d_id AND d_w_id = param_w_id into n_var_d_next_o_id,n_var_d_tax FOR UPDATE;
    UPDATE bmsql_district set  d_next_o_id =  d_next_o_id + 1
    WHERE d_id = param_d_id AND d_w_id = param_w_id;

-- create order
INSERT INTO bmsql_oorder(o_id, o_d_id, o_w_id, o_c_id, o_entry_d, o_ol_cnt, o_all_local)
VALUES (n_var_d_next_o_id, param_d_id, param_w_id, param_c_id, n_var_datetime, param_o_ol_cnt, param_o_all_local);

-- create unshipped orders
INSERT INTO bmsql_new_order (no_o_id, no_d_id, no_w_id)
VALUES (n_var_d_next_o_id, param_d_id, param_w_id);

-- circulation processing for every item
while var_ol_number <= param_o_ol_cnt do
      -- decoding warehouse, item-id, item-qty
      set var_ol_supply_w_id= substring_index(substring_index(param_supware, ',', var_ol_number), ',', -1);
      set var_ol_i_id= substring_index(substring_index(param_itemid, ',', var_ol_number), ',', -1);
      set var_ol_quantity= substring_index(substring_index(param_qyt, ',', var_ol_number), ',', -1);
      set var_remote = 0;
      if var_ol_supply_w_id != param_w_id then
        set var_remote = 1;
      end if;

    -- polarx replace returning
    select (case when s_quantity >= var_ol_quantity  then s_quantity else s_quantity + 91 end ) - var_ol_quantity, s_data,
       (case param_d_id
            when 1 then s_dist_01
            when 2 then s_dist_02
            when 3 then s_dist_03
            when 4 then s_dist_04
            when 5 then s_dist_05
            when 6 then s_dist_06
            when 7 then s_dist_07
            when 8 then s_dist_08
            when 9 then s_dist_09
            else s_dist_10
           end ) from bmsql_stock WHERE s_i_id = var_ol_i_id
                                    AND s_w_id = var_ol_supply_w_id into var_s_quantity, var_s_data, var_ol_dist_info FOR UPDATE;

    UPDATE bmsql_stock set s_order_cnt = s_order_cnt + 1,s_ytd = s_ytd + var_ol_quantity,s_remote_cnt = s_remote_cnt + var_remote,
                       s_quantity = (case when s_quantity >= var_ol_quantity  then s_quantity else s_quantity + 91 end ) - var_ol_quantity
    WHERE s_i_id = var_ol_i_id AND s_w_id = var_ol_supply_w_id;

    -- get item info
    SELECT i_price, i_name, (case when locate("original", i_data) and locate("original", var_s_data) then 'B' else 'G' end) as bg
    INTO var_i_price, var_i_name, var_bg FROM bmsql_item WHERE i_id = var_ol_i_id;

    -- calculate amount
    set var_ol_amount= var_ol_quantity * var_i_price;
          set n_var_amount_total=n_var_amount_total + var_ol_amount;

          -- insert the order details
    INSERT INTO bmsql_order_line (ol_o_id, ol_d_id, ol_w_id, ol_number, ol_i_id, ol_supply_w_id, ol_quantity, ol_amount, ol_dist_info)
    VALUES (n_var_d_next_o_id, param_d_id, param_w_id, var_ol_number, var_ol_i_id, var_ol_supply_w_id, var_ol_quantity, var_ol_amount, var_ol_dist_info);

    set n_item_data = concat_ws(',', n_item_data, var_ol_supply_w_id, var_ol_i_id, var_ol_quantity, var_i_name, var_s_quantity, var_bg, var_i_price, var_ol_amount) ;
    set var_ol_number= var_ol_number+1;

end while;

    set n_var_amount_total=n_var_amount_total * (1 + n_var_w_tax + n_var_d_tax) * (1 - n_var_c_discount);
    if err = 0 then
        select err,n_item_data,n_var_amount_total,n_var_c_credit,n_var_c_discount,n_var_c_last,n_var_d_next_o_id,n_var_d_tax,n_var_datetime,n_var_w_tax;
        commit;
    end if;
end;
-- do not delete separator


-- payment
DROP PROCEDURE IF EXISTS payment_tpcc;
-- do not delete separator

CREATE PROCEDURE payment_tpcc(in wid int,
                              in account float,
                              in did int,
                              in byname int,
                              in p_cwid int,
                              in p_cdid int,
                              in p_cid_in int,
                              in lastname char(17))
    label:begin
    declare num int;
    declare err int;
    declare p_datetime char(81);
    declare p_wstreet1 varchar(20);
    declare p_wstreet2 varchar(20);
    declare p_wcity varchar(20);
    declare p_wstate char(2);
    declare p_wzip char(9);
    declare p_wname char(11);
    declare p_dstreet1 varchar(20);
    declare p_dstreet2 varchar(20);
    declare p_dcity varchar(20);
    declare p_dstate char(2);
    declare p_dzip char(9);
    declare p_dname char(11);
    declare p_cid int;
    declare p_cfirst varchar(16);
    declare p_cmiddle char(2);
    declare p_clast char(17);
    declare p_cstreet1 varchar(20);
    declare p_cstreet2 varchar(20);
    declare p_ccity varchar(20);
    declare p_cstate char(2);
    declare p_czip char(9);
    declare p_cphone char(16);
    declare p_ccredit char(2);
    declare p_ccreditlim bigint;
    declare p_cdiscount decimal(4,2);
    declare p_cbalance decimal(12,2);
    declare p_csince char(81);
    declare p_cdata text(502);

    declare exit HANDLER FOR NOT FOUND
    begin
      set err = -1;
        select err,p_cbalance,p_ccity,p_ccredit,p_ccreditlim,p_cdata,p_cdiscount,p_cfirst,p_cid,p_clast,p_cmiddle,p_cphone,p_csince,p_cstate,
       p_cstreet1,p_cstreet2,p_czip,p_datetime,p_dcity,p_dname,p_dstate,p_dstreet1,p_dstreet2,p_dzip,p_wcity,p_wname,p_wstate,p_wstreet1,p_wstreet2,p_wzip;
        rollback;
    end;

    START TRANSACTION;
    set err = 0;
    SELECT CURRENT_TIMESTAMP() into p_datetime;
    set p_cid=p_cid_in;

    if byname=1 then
        SELECT count(c_id) INTO num FROM bmsql_customer WHERE c_w_id = p_cwid AND c_d_id = p_cdid AND c_last = lastname;
        if num = 0 then
            set err = -1;
            select err,p_cbalance,p_ccity,p_ccredit,p_ccreditlim,p_cdata,p_cdiscount,p_cfirst,p_cid,p_clast,p_cmiddle,p_cphone,p_csince,p_cstate,
           p_cstreet1,p_cstreet2,p_czip,p_datetime,p_dcity,p_dname,p_dstate,p_dstreet1,p_dstreet2,p_dzip,p_wcity,p_wname,p_wstate,p_wstreet1,p_wstreet2,p_wzip;
            rollback;
            leave label;
        end if;
          set num= cast(floor(num/2) as unsigned);
        SELECT c_id into p_cid FROM bmsql_customer WHERE c_w_id = p_cwid AND c_d_id = p_cdid AND c_last = lastname ORDER BY c_first limit num,1;
    end if;

    -- polarx replace returning
        select c_first, c_middle, c_last, c_street_1, c_street_2, c_city, c_state, c_zip, c_phone, c_credit, c_credit_lim, c_discount, c_balance - account, c_since from bmsql_customer
            where c_w_id = p_cwid AND c_d_id = p_cdid AND c_id = p_cid
            into p_cfirst, p_cmiddle, p_clast, p_cstreet1, p_cstreet2, p_ccity, p_cstate, p_czip, p_cphone, p_ccredit, p_ccreditlim, p_cdiscount, p_cbalance, p_csince FOR UPDATE;

        UPDATE bmsql_customer set c_balance= c_balance - account, c_ytd_payment = c_ytd_payment + account, c_payment_cnt = c_payment_cnt + 1
            where c_w_id = p_cwid AND c_d_id = p_cdid AND c_id = p_cid;
        -- polarx replace returning
        if p_ccredit="BC" then
            select substr(substr(concat(p_cid,' ',p_cdid,' ',p_cwid,' ',did,' ',wid,' ',account,' | ',c_data),1,500), 1, 200) from bmsql_customer WHERE c_w_id = p_cwid AND c_d_id = p_cdid AND c_id = p_cid  INTO p_cdata FOR UPDATE;
            UPDATE bmsql_customer SET c_data = substr(concat(p_cid,' ',p_cdid,' ',p_cwid,' ',did,' ',wid,' ',account,' | ',c_data),1,500)
                WHERE c_w_id = p_cwid AND c_d_id = p_cdid AND c_id = p_cid;
        else
          set p_cdata = '';
        end if;

        -- polarx replace returning
        select d_name, d_street_1, d_street_2, d_city, d_state, d_zip from bmsql_district WHERE d_w_id =wid AND d_id = did INTO p_dname, p_dstreet1, p_dstreet2, p_dcity, p_dstate, p_dzip FOR UPDATE;
        UPDATE bmsql_district SET d_ytd = d_ytd + account
            WHERE d_w_id =wid AND d_id = did;
        -- polarx replace retuning
        select w_name, w_street_1, w_street_2, w_city, w_state, w_zip from bmsql_warehouse WHERE w_id =wid INTO p_wname, p_wstreet1, p_wstreet2, p_wcity, p_wstate, p_wzip FOR UPDATE;
        UPDATE bmsql_warehouse SET w_ytd = w_ytd + account
            WHERE w_id =wid;

        INSERT INTO bmsql_history(h_c_d_id, h_c_w_id, h_c_id, h_d_id, h_w_id, h_date, h_amount, h_data)
        VALUES(p_cdid, p_cwid, p_cid, did, wid, p_datetime, account, concat(p_wname,' ',p_dname) );

        if err = 0 then
            select err,p_cbalance,p_ccity,p_ccredit,p_ccreditlim,p_cdata,p_cdiscount,p_cfirst,p_cid,p_clast,p_cmiddle,p_cphone,p_csince,p_cstate,
           p_cstreet1,p_cstreet2,p_czip,p_datetime,p_dcity,p_dname,p_dstate,p_dstreet1,p_dstreet2,p_dzip,p_wcity,p_wname,p_wstate,p_wstreet1,p_wstreet2,p_wzip;
            commit;
        else
          set err = -1;
        rollback;
end if;
end;
-- do not delete separator

-- order status
DROP PROCEDURE IF EXISTS order_status_tpcc;
-- do not delete separator

CREATE PROCEDURE order_status_tpcc(
    in wid int,
    in d_id_arg int,
    in c_id_arg int,
    in bylastname int,
    in c_last_arg varchar(16))
    label:begin
    declare itemnum int default 0;
    declare done int default 0;
    declare ol_i_id_arg int;
    declare ol_supply_w_id_arg int;
    declare ol_quantity_arg tinyint;
    declare ol_amount_arg  decimal(6,2);
    declare ol_delivery_d_arg datetime;
    declare namecnt int;
    declare rowindex int;
    declare c_id_arg_out int;
    declare c_balance_arg decimal(12,2);
    declare c_first_arg varchar(16);
    declare c_middle_arg char(2);
    declare c_last_arg_out varchar(16);
    declare o_id_arg int;
    declare o_entry_d_arg datetime;
    declare o_carrier_id_arg tinyint;
    declare item_data text;
    declare err int default 0;

    declare exit HANDLER FOR NOT FOUND
begin
      set err = -1;
select err, c_id_arg_out, c_balance_arg, c_first_arg, c_middle_arg, c_last_arg_out, o_id_arg, o_entry_d_arg, o_carrier_id_arg, item_data;
rollback;
end;
START TRANSACTION;
set err = 0;
    -- if bylastname is not 0,get cid by c_last_arg
    if bylastname != 0 then
SELECT count(c_id) INTO namecnt FROM bmsql_customer WHERE c_w_id = wid AND c_d_id = d_id_arg AND c_last = c_last_arg;
if namecnt = 0 then  #cannot find one record
        set err = -1;
select err, c_id_arg_out, c_balance_arg, c_first_arg, c_middle_arg, c_last_arg_out, o_id_arg, o_entry_d_arg, o_carrier_id_arg, item_data;
rollback;
leave label;
end if;
      set rowindex = cast(floor(namecnt/2) as unsigned);
SELECT c_id into c_id_arg  FROM bmsql_customer WHERE c_w_id = wid  AND c_d_id = d_id_arg  AND c_last = c_last_arg order by c_first limit rowindex,1;
end if;

    set c_id_arg_out = c_id_arg;
SELECT c_balance, c_first, c_middle, c_last into c_balance_arg,c_first_arg,c_middle_arg,c_last_arg_out
FROM bmsql_customer WHERE c_w_id = wid AND c_d_id = d_id_arg AND c_id = c_id_arg;

-- find the most recent order for this customer
SELECT o_id, o_entry_d, COALESCE(o_carrier_id,0) into o_id_arg,o_entry_d_arg,o_carrier_id_arg
FROM bmsql_oorder WHERE o_w_id = wid AND o_d_id = d_id_arg AND o_c_id = c_id_arg order by o_id desc limit 1;

begin
      DECLARE cur CURSOR FOR
SELECT ol_i_id, ol_supply_w_id, ol_quantity, ol_amount, ol_delivery_d
FROM bmsql_order_line WHERE ol_w_id = wid AND ol_d_id = d_id_arg AND ol_o_id = o_id_arg;
DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = 1;
OPEN cur;
while done != 1 do
        FETCH cur INTO ol_i_id_arg, ol_supply_w_id_arg, ol_quantity_arg, ol_amount_arg, ol_delivery_d_arg;
        if done != 1 then
          if isnull(ol_delivery_d_arg) then
            set item_data = concat_ws(',', item_data, ol_i_id_arg, ol_supply_w_id_arg, ol_quantity_arg, ol_amount_arg, 'NULL');
else
            set  item_data  = concat_ws(',', item_data, ol_i_id_arg, ol_supply_w_id_arg, ol_quantity_arg, ol_amount_arg, ol_delivery_d_arg);
end if;
end if;
end while;
CLOSE cur;
end;

select err, c_id_arg_out, c_balance_arg, c_first_arg, c_middle_arg, c_last_arg_out, o_id_arg, o_entry_d_arg, o_carrier_id_arg, item_data;
commit;
end;
-- do not delete separator


-- delivery
drop procedure if exists delivery_tpcc;
-- do not delete separator

CREATE PROCEDURE delivery_tpcc(in wid int,in o_carrier_id_arg int)
begin
    declare var_ol_number int default 1; -- cycles
    declare real_no_o_id int;
    declare cid int;
    declare dtime datetime;
    declare total_ol_amount decimal(12,2);
    declare delivery_order_ids varchar(128);
    declare errinfo varchar(128);

select CURRENT_TIMESTAMP() into dtime;
START TRANSACTION;

myloop:
      while var_ol_number <= 10 do
        -- DELETE FROM new_orders WHERE no_w_id = wid AND no_d_id = var_ol_number order by no_o_id asc limit 1 txsql_returning no_o_id into real_no_o_id ;

        -- polarx replace returning
select no_o_id from bmsql_new_order WHERE no_w_id = wid AND no_d_id = var_ol_number order by no_o_id asc limit 1 into real_no_o_id FOR UPDATE;
DELETE FROM bmsql_new_order WHERE no_w_id = wid AND no_d_id = var_ol_number order by no_o_id asc limit 1;

if found_rows() > 0 then

      -- polarx replace returning
select o_c_id from bmsql_oorder WHERE  o_w_id = wid AND o_d_id = var_ol_number AND o_id = real_no_o_id into cid FOR UPDATE;
UPDATE bmsql_oorder SET o_carrier_id = o_carrier_id_arg WHERE  o_w_id = wid AND o_d_id = var_ol_number AND o_id = real_no_o_id;
if ROW_COUNT( ) != 1 then
            set errinfo = concat("update orders can't find,for no_d_id:",var_ol_number);
              leave myloop;
end if;

UPDATE bmsql_order_line SET ol_delivery_d = dtime WHERE ol_o_id = real_no_o_id AND ol_d_id = var_ol_number AND ol_w_id = wid;
if ROW_COUNT( ) < 1 then
            set errinfo = concat("update order_line can't find,for no_d_id:",var_ol_number);
            leave myloop;
end if;

SELECT SUM(ol_amount) into total_ol_amount FROM bmsql_order_line WHERE ol_o_id = real_no_o_id AND ol_d_id = var_ol_number AND ol_w_id = wid;
if ROW_COUNT( ) != 1 then
            set errinfo = concat("sum(total_ol_amount) can't find,for no_d_id:",var_ol_number);
            leave myloop;
end if;

UPDATE bmsql_customer SET c_balance = c_balance + total_ol_amount , c_delivery_cnt = c_delivery_cnt + 1 WHERE c_id = cid AND c_d_id = var_ol_number AND c_w_id = wid;
if ROW_COUNT( ) != 1 then
            set errinfo = concat("update  customer can't find,for no_d_id:",var_ol_number);
            leave myloop;
end if;

		  set delivery_order_ids = concat_ws(',', delivery_order_ids, real_no_o_id);
end if;

        set var_ol_number = var_ol_number + 1;

end while myloop;

select delivery_order_ids, errinfo;
if isnull(errinfo) then
        commit;
else
        rollback;
end if;
end;
-- do not delete separator


-- stock level
DROP PROCEDURE IF EXISTS stock_level_tpcc;
-- do not delete separator

CREATE PROCEDURE stock_level_tpcc(in w_id_arg int,
                                  in d_id_arg int,
                                  in level_arg int)
begin
    declare low_stock int;

START TRANSACTION;
SELECT COUNT(DISTINCT (s_i_id)) into low_stock
FROM bmsql_order_line, bmsql_stock, bmsql_district
WHERE d_w_id = ol_w_id AND ol_w_id = s_w_id AND d_w_id = w_id_arg AND d_id = ol_d_id AND d_id = d_id_arg
  AND ol_i_id = s_i_id  AND s_quantity < level_arg AND ol_o_id BETWEEN (d_next_o_id - 20) AND (d_next_o_id - 1);

select low_stock;
commit;
end;