/*
 * ExecJDBC - Command line program to process SQL DDL statements, from
 *             a text input file, to any JDBC Data Source
 *
 * Copyright (C) 2004-2016, Denis Lussier
 * Copyright (C) 2016, Jan Wieck
 *
 */

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class SourceJDBC {


  public static void main(String[] args) {

    Connection conn = null;
    Statement stmt = null;
    String rLine = null;

    try {

    Properties ini = new Properties();
    ini.load( new FileInputStream(System.getProperty("prop")));

    // Register jdbcDriver
    Class.forName(ini.getProperty( "driver" ));

    // make connection
    conn = DriverManager.getConnection(ini.getProperty("conn"),
      ini.getProperty("user"),ini.getProperty("password"));
    conn.setAutoCommit(true);

    // Create Statement
    stmt = conn.createStatement();

      // Open inputFile
      BufferedReader in = new BufferedReader
          (new FileReader(jTPCCUtil.getSysProp("commandFile",null)));
      StringBuilder sb = new StringBuilder(4096);
      // loop thru input file and concatenate SQL statement fragments
      while((rLine = in.readLine()) != null) {
        if (rLine.startsWith("-- do not delete separator")) {
          execJDBC(stmt, sb.toString());
          sb.setLength(0);
          continue;
        }
        sb.append(rLine + "\n");
        if (rLine.startsWith("DROP")) {
          System.out.println(rLine);
        }
        if (rLine.startsWith("CREATE")) {
          System.out.println(rLine + "...");
        }
      } //end while

      in.close();

      execJDBC(stmt, sb.toString());
    } catch(IOException ie) {
        System.out.println(ie.getMessage());

    } catch(SQLException se) {
        System.out.println(se.getMessage());

    } catch(Exception e) {
        e.printStackTrace();

    //exit Cleanly
    } finally {
      try {
        if (conn !=null)
           conn.close();
      } catch(SQLException se) {
        se.printStackTrace();
      } // end finally

    } // end try

  } // end main


  static void execJDBC(Statement stmt, String query) {
    try {
      stmt.execute(query);
    }catch(SQLException se) {
      System.err.println(se.getMessage());
    } // end try

  } // end execJDBCCommand

} // end ExecJDBC Class
