#!/bin/bash
set -euo pipefail
trap "" EXIT

echo "Installing libraries..."

if [ -f "/etc/redhat-release" ]; then
    yum install -y make automake libtool mysql-devel mysql java-11-openjdk.x86_64 > /dev/null
elif [ -f "/etc/lsb-release" ]; then
    apt update
    apt install -y make automake pkg-config mysql-client-core-5.7 libmysqlclient-dev openjdk-11-jre  > /dev/null
else 
    echo "Unknown system"
    exit 1
fi

_java="java"
java_version=$("$_java" -version 2>&1 | head -1 | cut -d'"' -f2 | sed 's/^1\.//' | cut -d'.' -f1)
target_version=11
if [ "$java_version" -lt "$target_version" ]; then
    echo "Java 11 or higher is required, but current java version is $java_version"
    echo "Please specify java path with version 11 in install-and-run.sh"
    exit 1
fi

if [ ! -d "tpch" ]; then
  mv TPCH/ tpch/
fi

echo "Installing sysbench..."
cd sysbench/
./autogen.sh
make --silent -j install > /dev/null
cd ..

echo "Installing transfer..."
cp transfer/transfer /usr/local/bin/

pwd=$PWD

echo "Starting benchmark-boot..."
nohup java -jar ./benchmark-boot.jar --spring.profiles.active=pro --benchmark-path.root-dir="$pwd" >/dev/null 2>&1 &

sleep 5
pid=$(ps x | grep "benchmark-boot.jar" | grep -v grep | awk '{print $1}')
if [ "$pid" = "" ]; then
    echo "Failed to start benchmark-boot."
    echo "Please restart benchmark-boot.jar manually and find the cause."
else
    echo "Benchmark-boot (PID: $pid) is running..."
fi