-- Provide functions to supported timed event() call

function init()
  assert(event ~= nil,
         "this script is meant to be included by other scripts and " ..
            "should not be called directly.")
end


math_floor = math.floor

ffi = require("ffi")

ffi.cdef[[
  typedef long time_t;
  typedef int clockid_t;
  typedef struct timespec {
          time_t   tv_sec;        /* seconds */
          long     tv_nsec;       /* nanoseconds */
  } nanotime;
  int clock_gettime(clockid_t clk_id, struct timespec *tp);
  int usleep(int microseconds);
  int shmget(int key,int size,int flag);
  void * shmat(int shmid,const void* ptr,int flag);
  char * strcpy(char * dest,const char* src);
]]

MAX_RETRY = 1800  -- Max retry times to connect before error out

function timed_event_init()
  -- Establish shm communication area for tps controll if needed
  if sysbench.opt.target_tps_shm_key ~= nil and sysbench.opt.target_tps_shm_key ~= -1 then
    local IPC_CREAT = 01000
    local shmid = ffi.C.shmget(sysbench.opt.target_tps_shm_key,10,IPC_CREAT)
    local ptr = ffi.C.shmat(shmid,nil,0)
    local text = tostring(sysbench.opt.target_tps)
    local c_str = ffi.new("char[?]", #text)
    ffi.copy(c_str, text)
    local str = ffi.cast("char *",ptr)
    ffi.C.strcpy(str,c_str)
  end
  
  prv_time = 0
  cur_time = 0
  shm_read_time = 0
  target_tps = sysbench.opt.target_tps
  if target_tps > 0 then
    diff_target = math_floor(1 / target_tps * 1000000 * sysbench.opt.threads)  -- Convert TPS target to microseconds target gap
    sleep_time = diff_target
  end
end

function throttle_event()
  if sysbench.opt.target_tps > 0 or (sysbench.opt.target_tps_shm_key ~= nil and sysbench.opt.target_tps_shm_key ~= -1) then
    -- Calculation sleep time for each thread so that we can meet the TPS target
    -- Get local timestamp with nano-second resolution
    local pnano = assert(ffi.new("nanotime[?]", 1))
    ffi.C.clock_gettime(1, pnano)
    -- Convert to microseconds
    cur_time = tonumber(pnano[0].tv_sec*1000000) + math_floor(tonumber(pnano[0].tv_nsec/1000))
    -- dynamic load target tps from shared memory
    if sysbench.opt.target_tps_shm_key ~= nil and sysbench.opt.target_tps_shm_key ~= -1 then
      if shm_read_time == 0 then
        shm_read_time = cur_time
      end
      if cur_time - shm_read_time > 1000000 then -- refresh config every 1 second
        local shmid = ffi.C.shmget(sysbench.opt.target_tps_shm_key,10,0)
        if shmid==-1 then
          print('Fail to get shared memory')
          os.exit(0)
        end
        local ptr = ffi.C.shmat(shmid,nil,0)
        local str = ffi.cast('char *',ptr)
        local text1 = ffi.string(str,10)
        sysbench.opt.target_tps = tonumber(text1)
        if sysbench.opt.target_tps > 0 then
          diff_target = math_floor(1 / sysbench.opt.target_tps * 1000000 * sysbench.opt.threads)  -- Convert TPS target to microseconds target gap
          sleep_time = diff_target
        end
        shm_read_time = cur_time
      end
    end
    -- sleep if target-tps > 0
    if sysbench.opt.target_tps > 0 then
      if prv_time == 0 then
        prv_time = cur_time
      else
        time_diff = tonumber(cur_time -  prv_time)
        prv_time = cur_time
        sleep_time = sleep_time + diff_target - time_diff
        if sleep_time < 0 then 
            sleep_time = 0
        end
      end
      ffi.C.usleep(sleep_time)
    end
  end
end



